<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type CustomReportDataFieldInput
 * A custom report data field * @property bool $allowsFilter Whether the data field allows filters or not
 * @property null|string $columnHeaderPrefix = null The column header prefix of the data field
 * @property null|FieldDescriptionInputInputType $dbFieldDescr = null The data field description
 * @property null|FieldDescriptionInputInputType $fieldDescription = null The field description
 * @property null|iterable|DataElementFilterInputInputType[] $filters = null The custom report filters of the data field
 * @property null|string $prefix = null The custom report data field prefix
 * @property null|string $field = null The field name
 * @property null|bool $isResizable = null A flag whether this column is resizable or not
 * @property null|bool $isSortable = null A flag whether this column is sortable
 * @property null|bool $isSticky = null A flag whether this column can be sticky or not
 * @property null|bool $isVisible = null A flag whether this column is visible or not
 */
final class CustomReportDataFieldInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'dbFieldDescr') {
            return new FieldDescriptionInputInputType($value);
        }

        if ($name === 'fieldDescription') {
            return new FieldDescriptionInputInputType($value);
        }

        if ($name === 'filters') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DataElementFilterInputInputType($v)); })($value);
        }

        return $value;
    }
}