<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type DiscoveryJobInput
 * A discovery job object. A discovery job is a definition of networks, domains, AD entries to be scanned. There can be multiple jobs scanning different areas or the network. * @property null|bool $agingOutCompleted = null Sync directories trees.
 * @property null|string $description = null The description for the job.
 * @property null|iterable|DiscoveryDeviceQueueItemInputInputType[] $deviceQueueEntries = null The list of device queue entries for this discovery job.
 * @property null|bool $directorySyncComputerAccounts = null Sync computer accounts.
 * @property null|bool $directorySyncDirectoryTree = null Sync directories trees.
 * @property null|bool $directorySyncNetworks = null Sync directories even on networks.
 * @property null|bool $directorySyncUserGroups = null Sync user groups.
 * @property null|bool $directorySyncUsers = null Sync users.
 * @property null|string $discoveryCloudSyncLog = null The discovery cloud sync log as XML string.
 * @property null|string $discoveryConfigLog = null The discovery config log as XML string.
 * @property null|string $discoveryDirectoryLog = null The discovery directory log as XML string.
 * @property null|string $discoveryDirectorySyncLog = null The discovery directory sync log as XML string.
 * @property null|string $discoveryNetworkNeighborhoodLog = null The discovery network neighborhood log as XML string.
 * @property null|string $discoveryNetworkSyncLog = null The discovery network sync log as XML string.
 * @property null|string $discoveryPingLog = null The discovery ping log as XML string.
 * @property null|int $doNotDiscoverTwiceWithinNSeconds = null Minimum time between two discovery jobs.
 * @property null|ScheduleInputInputType $executionSchedule = null The execution schedule of this job
 * @property mixed $lastFinishedAt = null The last timestamp the job was finished.
 * @property mixed $lastStartAt = null The last timestamp the job was started.
 * @property mixed $logModificationTime = null The discovery config log modification time.
 * @property null|int $maxConcurrentDevices = null Maximum number of devices parallel discovered.
 * @property null|string $name = null The name for the job.
 * @property null|TaskStatusEnum $status = null The status of the job.
 * @property null|bool $syncCloudServices = null Sync cloud services.
 */
final class DiscoveryJobInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'deviceQueueEntries') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DiscoveryDeviceQueueItemInputInputType($v)); })($value);
        }

        if ($name === 'executionSchedule') {
            return new ScheduleInputInputType($value);
        }

        if ($name === 'status') {
            return new TaskStatusEnum($value);
        }

        return $value;
    }
}