<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type IP6NetworkInput
 * An IP6 network holding the IP address base address, prefix length and network name * @property null|iterable|DeviceInputInputType[] $devices = null The list of devices belonging to this network.
 * @property null|string $firstAddress = null The IPv6 network's first IP address.
 * @property null|string $lastAddress = null The IPv6 network's last IP address.
 * @property null|string $name = null The IPv6 network's name.
 * @property null|bool $nameManuallyConfigured = null A flag that indicates whether the network's name has been configured manually or whether it has been discovered (e.g. via AD).
 * @property null|string $networkBaseAddress = null The IPv6 network's base address.
 * @property null|IP6NetworkInputInputType $parentNetwork = null A network's parent network (if it exists).
 * @property null|int $prefixLength = null An IP6 network's configured prefix length.
 * @property null|iterable|IP6TransportInputInputType[] $transports = null The list of IP6 transports associated with this network.
 */
final class IP6NetworkInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'devices') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DeviceInputInputType($v)); })($value);
        }

        if ($name === 'parentNetwork') {
            return new IP6NetworkInputInputType($value);
        }

        if ($name === 'transports') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IP6TransportInputInputType($v)); })($value);
        }

        return $value;
    }
}