<?php

declare (strict_types=1);
namespace idoit\Module\JDisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type OperatingSystemInput
 * The operating system for a specific device. * @property null|iterable|ApplicationInstanceInputInputType[] $applicationInstances = null The list of all application instances (e.g. database instances, web server instances, ...).
 * @property null|iterable|ClientAccessLicenseInputInputType[] $clientAccessLicenses = null Gets the list of client access licenses for this operating system
 * @property mixed $compileTime = null The operating system compile time
 * @property null|string $description = null The operating system description
 * @property null|string $id = null The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
 * @property mixed $installDate = null The operating system's install date
 * @property null|iterable|InstalledApplicationInputInputType[] $installedApplications = null The list of installed applications.
 * @property null|iterable|InstalledCertificateInputInputType[] $installedCertificates = null The list of installed certificates.
 * @property null|iterable|InstalledEndpointSecuritySoftwareInputInputType[] $installedEndpointSecurityApplications = null The list of installed endpoint security applications.
 * @property null|iterable|InstalledPatchInputInputType[] $installedPatches = null The list of installed patches.
 * @property null|iterable|InstalledServiceInputInputType[] $installedServices = null The list of installed services.
 * @property null|iterable|IssuedClientAccessLicenseInputInputType[] $issuedClientAccessLicenses = null Gets the list of issued client access licenses for this operating system
 * @property null|string $kernelVersion = null The kernel version
 * @property mixed $lastUpdateTime = null The operating system's last update time
 * @property null|string $licenseComment = null The operating system's license comment
 * @property mixed $licenseExpirationDate = null The operating system's license expiration date
 * @property null|SoftwareLicenseStatusEnum $licenseStatus = null The operating system's license status
 * @property null|LicenseTypeEnum $licenseType = null The license type
 * @property null|iterable|LocalUserInputInputType[] $localUsers = null Gets the list of users which belong to this operating system.
 * @property null|string $locale = null The locale that is used for this operating system
 * @property null|int $localeCode = null The locale code that is used for this operating system
 * @property null|iterable|LoggedOnUserInputInputType[] $loggedOnUsers = null Gets the list of logged-on users to this operating system
 * @property null|iterable|LoggedOnUserInputInputType[] $loggedOnUsersHistory = null Gets the list of history logged-on users to this operating system
 * @property null|string $manufacturer = null The operating system's manufacturer
 * @property null|iterable|MappedPrinterInputInputType[] $mappedPrinters = null The list of all mapped printers.
 * @property null|string $osFamily = null The operating system family (e.g. Windows, Linux, HP-UX, ...)
 * @property null|string $osVersion = null The operating system version (e.g. Windows 10, Windows 2008 Server, ...)
 * @property null|string $owner = null The patch level (e.g. Service Pack 3)
 * @property null|string $patchLevel = null The patch level (e.g. Service Pack 3)
 * @property null|iterable|PendingUpdateItemInputInputType[] $pendingUpdates = null The list of pending installations.
 * @property null|iterable|ProcessInputInputType[] $processes = null The list of all processes running on this operating system.
 * @property null|string $productKey = null The operating system product key
 * @property null|string $rawVersion = null The raw version as it gets delivered by the operating system
 * @property null|bool $rebootRequired = null Is a reboot required to finalize the installation of pending patches?
 * @property null|iterable|SshCipherAlgorithmInputInputType[] $sshCipherAlgorithms = null Gets the list of ssh cipher algorithms supported by the operating systems's SSH server
 * @property null|iterable|SshKeyExchangeAlgorithmInputInputType[] $sshKeyExchangeAlgorithms = null Gets the list of ssh key-exchange algorithms supported by the operating systems's SSH server
 * @property null|iterable|SshMacAlgorithmInputInputType[] $sshMACAlgorithms = null Gets the list of ssh MAC algorithms supported by the operating systems's SSH server
 * @property null|string $systemType = null The device's system type (e.g. x64, x86, arm, ...)
 * @property mixed $systemUpTime = null The uptime in milliseconds
 * @property null|string $timezoneName = null The timezone name
 * @property null|string $uniqueId = null The operating system's unique id
 * @property null|int $utcOffset = null The UTC offset for the configured timezone
 * @property null|DeviceInputInputType $device = null The device that this operating system is installed on.
 */
final class OperatingSystemInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'applicationInstances') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ApplicationInstanceInputInputType($v)); })($value);
        }

        if ($name === 'clientAccessLicenses') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ClientAccessLicenseInputInputType($v)); })($value);
        }

        if ($name === 'installedApplications') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new InstalledApplicationInputInputType($v)); })($value);
        }

        if ($name === 'installedCertificates') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new InstalledCertificateInputInputType($v)); })($value);
        }

        if ($name === 'installedEndpointSecurityApplications') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new InstalledEndpointSecuritySoftwareInputInputType($v)); })($value);
        }

        if ($name === 'installedPatches') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new InstalledPatchInputInputType($v)); })($value);
        }

        if ($name === 'installedServices') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new InstalledServiceInputInputType($v)); })($value);
        }

        if ($name === 'issuedClientAccessLicenses') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IssuedClientAccessLicenseInputInputType($v)); })($value);
        }

        if ($name === 'licenseStatus') {
            return new SoftwareLicenseStatusEnum($value);
        }

        if ($name === 'licenseType') {
            return new LicenseTypeEnum($value);
        }

        if ($name === 'localUsers') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new LocalUserInputInputType($v)); })($value);
        }

        if ($name === 'loggedOnUsers') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new LoggedOnUserInputInputType($v)); })($value);
        }

        if ($name === 'loggedOnUsersHistory') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new LoggedOnUserInputInputType($v)); })($value);
        }

        if ($name === 'mappedPrinters') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new MappedPrinterInputInputType($v)); })($value);
        }

        if ($name === 'pendingUpdates') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new PendingUpdateItemInputInputType($v)); })($value);
        }

        if ($name === 'processes') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new ProcessInputInputType($v)); })($value);
        }

        if ($name === 'sshCipherAlgorithms') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new SshCipherAlgorithmInputInputType($v)); })($value);
        }

        if ($name === 'sshKeyExchangeAlgorithms') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new SshKeyExchangeAlgorithmInputInputType($v)); })($value);
        }

        if ($name === 'sshMACAlgorithms') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new SshMacAlgorithmInputInputType($v)); })($value);
        }

        if ($name === 'device') {
            return new DeviceInputInputType($value);
        }

        return $value;
    }
}