<?php
/**
 * i-doit
 *
 * Static constant not registered by the dynamic constant manager.
 * Please empty this list every major release.
 *
 * @package     i-doit
 * @subpackage  General
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

$systemSettings = isys_application::instance()->container->get('settingsSystem');
$tenantSettings = isys_application::instance()->container->get('settingsTenant');
$userSettings = isys_application::instance()->container->get('settingsUser');
$session = isys_application::instance()->container->get('session');

// @see ID-6912 This can happen if `nostalgia` gets included before `import`.
if (defined('C__IMPORT__DIRECTORY')) {
    $csvImportDirectory = C__IMPORT__DIRECTORY;
} else {
    $uploadDir = $tenantSettings->get('system.dir.import-uploads', BASE_DIR . '/imports/');
    $csvImportDirectory = $tenantSettings->get('system.dir.csv-uploads', rtrim($uploadDir, '/') . '/') . $session->get_mandator_id() . '/';
}

$constants = [
    // System constants from table 'isys_const_system' (in 'idoit_system').
    'C__RECORD_PROPERTY__NOT_SHOW_IN_LIST'  => 16,

    // @todo Remove in 2026
    // Allow the update migrations.
    'C__UPDATE_MIGRATION'                   => true,
    // Category property's value type. Defaults to 'text'.
    'C__CATEGORY_DATA__FORMAT'              => 'format',
];

foreach ($constants as $constantName => $constantValue) {
    if (!defined($constantName)) {
        define($constantName, $constantValue);
    }
}
