<div id="attribute-settings-popup_delete">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__UNIVERSAL__DELETE"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content p10">
        [{if $canDelete}]
            [{if $plural}]
            <p>[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__DELETE_CONFIRMATION_PLURAL"}]</p>
            [{else}]
            <p>[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__DELETE_CONFIRMATION"}]</p>
            [{/if}]
        [{else}]
        <p class="box-red p10 mx10 mt10">[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__DELETE_NOT_ALLOWED"}]</p>
        [{/if}]
    </div>

    <div class="popup-footer">
        <button type="button" class="btn delete-button" [{if !$canDelete}]disabled[{/if}]>
            <img src="[{$dir_images}]axialis/industry-manufacturing/waste-bin.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_DELETE"}]</span>
        </button>

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>
<script type="text/javascript">
    (function () {
        'use strict';

        const $popup = $('attribute-settings-popup_delete');
        const $deleteButton = $popup.down('.delete-button');

        $popup.on('click', '.popup-closer', function () {
            popup_close();
        });

        /* [{if $canDelete}] */
        $deleteButton.on('click', function () {
            $deleteButton.disable()
                .down('img')
                .addClassName('animation-rotate')
                .writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg');

            new Ajax.Request(idoit.Router.getRoute('pro.attribute-settings.delete-attribute-setting'), {
                method:     'post',
                parameters: { ids: '[{$ids}]' },
                onComplete: function (xhr) {
                    if (!is_json_response(xhr, true)) {
                        return;
                    }

                    const json = xhr.responseJSON;

                    if (!json.success) {
                        idoit.Notify.error(json.message, {sticky: true});

                        $deleteButton.down('img')
                            .removeClassName('animation-rotate')
                            .writeAttribute('src', window.dir_images + 'axialis/industry-manufacturing/waste-bin.svg');

                        return;
                    }

                    idoit.Notify.success('[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__DELETED_NOTIFICATION"}]');

                    popup_close();

                    setTimeout(function () {
                        document.location.reload();
                    }, 500);
                }
            });
        });
        /* [{/if}] */
    })();
</script>
