<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     i-doit
 * @subpackage  Modules
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use idoit\Psr4AutoloaderClass;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\Routing\Loader\PhpFileLoader;

define('C__QRCODE__TYPE__ACCESS_URL', 0);
define('C__QRCODE__TYPE__SELFDEFINED', 1);
define('C__QRCODE__LINK__IQR', 'iqr');
define('C__QRCODE__LINK__PRINT', 'print');

if (class_exists(Autoloader::class) && file_exists(__DIR__ . '/classmap.php')) {
    Autoloader::appendClassmap(require __DIR__ . '/classmap.php');
}

if (class_exists(Psr4AutoloaderClass::class)) {
    Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\Qrcode', __DIR__ . '/src/');
}

isys_register::factory('additional-report-views')
    ->set(__DIR__ . '/reportview/isys_qrcode_reportview_qr_codes.class.php');
