<?php
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Component\Table\Filter\Source;

/**
 * Get query source
 *
 * @package idoit\Component\Table\Filter\Source
 */
class QueryMapSource implements SourceInterface
{
    private $map = [];

    public function add($name, $value)
    {
        $this->map[$name] = $value;
    }

    /**
     * Gets the stored data
     *
     * @return array
     */
    public function get(): array
    {
        $filter = [];
        foreach ($this->map as $k => $v) {
            if (isset($_GET[$k], $_GET[$v])) {
                $filter[$_GET[$k]] = $_GET[$v];
            }
        }

        return $filter;
    }
}
