<?php

namespace idoit\Module\Cmdb\Component\SyncMerger\DataRetriever;

use idoit\Component\Property\Property;
use isys_cmdb_dao_category;
use isys_request;

class ByCustomCategoryDataset extends ByDataset
{
    /**
     * @param string                 $propertyKey
     * @param Property               $property
     * @param array                  $properties
     * @param array                  $categoryData
     * @param array                  $currentData
     * @param isys_cmdb_dao_category $dao
     * @param isys_request|null      $request
     *
     * @return mixed|null
     */
    public function retrieveValue(
        string $propertyKey,
        Property $property,
        array $properties,
        array $categoryData,
        array $currentData,
        isys_cmdb_dao_category $dao,
        ?isys_request $request = null
    ) {
        $dbField = $property->getData()->getFieldAlias();

        $commentaryField = $dbField === 'C__CMDB__CAT__COMMENTARY_' . C__CMDB__CATEGORY__TYPE_CUSTOM . $dao->get_catg_custom_id();

        if ($commentaryField && isset($categoryData['description'])) {
            $dbField = 'description';
        }

        if (isset($categoryData[$dbField])) {
            return $categoryData[$dbField];
        }

        return null;
    }
}
