<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     Modules
 * @subpackage  Itservice
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_itservice_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $className
     *
     * @return  boolean
     */
    public static function init($className)
    {
        $addOnPath = '/src/classes/modules/itservice/';
        $classMap = [
            'isys_ajax_handler_itservice'           => 'handler/ajax/isys_ajax_handler_itservice.class.php',
            'isys_module_itservice_autoload'        => 'isys_module_itservice_autoload.class.php',
            'isys_auth_itservice'                   => 'auth/isys_auth_itservice.class.php',
            'isys_cmdb_dao_list_objects_it_service' => 'dao/isys_cmdb_dao_list_objects_it_service.class.php',
            'isys_itservice_dao_filter_config'      => 'dao/isys_itservice_dao_filter_config.class.php',
            'isys_itservice_dao_algorithm'          => 'dao/isys_itservice_dao_algorithm.class.php',
            'isys_module_itservice'                 => 'isys_module_itservice.class.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($addOnPath . $classMap[$className])) {
            isys_cache::keyvalue()->ns('autoload')->set($className, $addOnPath . $classMap[$className]);

            return true;
        }

        return false;
    }
}
