<?php

use idoit\Module\Pro\Controller\AttributeSettings\Configuration;
use idoit\Module\Pro\Controller\CategoryFolders\Config;
use idoit\Module\Pro\Controller\CmdbExplorer\Graph;
use idoit\Module\Pro\Controller\CmdbExplorer\Tree;
use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return function (RoutingConfigurator $routes) {
    $routes->add('pro.category-folders.load-config', '/ajax/category-folders/load-config/{objectTypeId}')
        ->methods(['GET'])
        ->requirements(['objectTypeId' => '\d*'])
        ->controller([Config::class, 'loadByObjectType']);

    $routes->add('pro.category-folders.save-config', '/ajax/category-folders/save-config/{objectTypeId}')
        ->methods(['POST'])
        ->requirements(['objectTypeId' => '\d*'])
        ->controller([Config::class, 'saveForObjectType']);

    $routes->add('pro.category-folders.edit-folder', '/ajax/category-folders/edit-folder')
        ->methods(['POST'])
        ->controller([Config::class, 'editFolder']);

    $routes->add('pro.category-folders.delete-folder', '/ajax/category-folders/delete-folder')
        ->methods(['POST'])
        ->controller([Config::class, 'deleteFolder']);

    $routes->add('pro.category-folders.move-item', '/ajax/category-folders/move-item')
        ->methods(['POST'])
        ->controller([Config::class, 'moveItem']);

    $routes->add('pro.category-folders.reset', '/ajax/category-folders/reset')
        ->methods(['POST'])
        ->controller([Config::class, 'reset']);

    $routes->add('pro.attribute-settings.load-configuration', '/ajax/attribute-settings/load-configuration')
        ->methods(['GET'])
        ->controller([Configuration::class, 'loadConfiguration']);

    $routes->add('pro.attribute-settings.load-attributes', '/ajax/attribute-settings/load-attributes')
        ->methods(['GET'])
        ->controller([Configuration::class, 'loadAttributes']);

    $routes->add('pro.attribute-settings.create-attribute-setting', '/ajax/attribute-settings/create-attribute-setting')
        ->methods(['POST'])
        ->controller([Configuration::class, 'createAttributeSetting']);

    $routes->add('pro.attribute-settings.delete-attribute-setting', '/ajax/attribute-settings/delete-attribute-setting')
        ->methods(['POST'])
        ->controller([Configuration::class, 'deleteAttributeSetting']);

    $routes->add('pro.attribute-settings.edit-attribute-setting', '/ajax/attribute-settings/edit-attribute-setting/{id}')
        ->methods(['POST'])
        ->requirements(['id' => '\d+'])
        ->controller([Configuration::class, 'editAttributeSetting']);

    $routes->add('pro.cmdb-explorer.tree.level', '/pro/cmdb-explorer/tree-level')
        ->methods(['GET'])
        ->controller([Tree::class, 'loadLevel']);

    $routes->add('pro.cmdb-explorer.tree.data', '/pro/cmdb-explorer/tree-data')
        ->methods(['GET'])
        ->controller([Tree::class, 'loadData']);

    $routes->add('pro.cmdb-explorer.graph.data', '/pro/cmdb-explorer/graph-data')
        ->methods(['GET'])
        ->controller([Graph::class, 'loadData']);
};
