<?php

/**
 * i-doit
 *
 * Popup class for category folders feature.
 *
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_category_folders_reorder extends isys_component_popup
{
    /**
     * Handles SMARTY request for dialog plus lists and builds the list base on the specified table.
     *
     * @param   isys_component_template & $p_tplclass
     * @param   array                   $p_params
     *
     * @return  string
     */
    public function handle_smarty_include(isys_component_template &$p_tplclass, $p_params)
    {
        $l_button_options = [
            'id'                => $p_params['name'],
            'icon'              => isys_application::instance()->www_path . 'images/axialis/documents-folders/document-edit.svg',
            'p_bInfoIconSpacer' => 0,
            'p_onClick'         => $this->getModalJs('', '70%', null, [], 640, 350, 'configuration'),
            'type'              => 'button',
            'p_strValue'        => $this->language->get('LC__CATEGORY_FOLDERS__REORDER'),
            'p_strClass'        => 'ml10',
            'p_bDisabled'       => true
        ];

        return (new isys_smarty_plugin_f_button())->navigation_edit($this->template, $l_button_options);
    }

    /**
     * Method for handling the module request.
     *
     * @param isys_module_request $p_modreq
     *
     * @return void
     * @throws \idoit\Exception\JsonException
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        // Unpack popup request.
        $parameters = isys_format_json::decode(base64_decode($_POST['params']));

        // Get the route generator.
        $routeGenerator = isys_application::instance()->container->get('route_generator');

        // Display the dialog template and return it.
        $this->template
            ->activate_editmode()
            ->assign('proWwwDir', isys_module_pro::getWwwPath())
            ->assign('objectTypeId', (int)$parameters['objectTypeId'])
            ->assign('loadConfigUrl', $routeGenerator->generate('pro.category-folders.load-config', ['objectTypeId' => (int)$parameters['objectTypeId']]))
            ->assign('saveConfigUrl', $routeGenerator->generate('pro.category-folders.save-config', ['objectTypeId' => (int)$parameters['objectTypeId']]))
            ->display(dirname(__DIR__) . '/templates/SettingPage/CategoryFolders/popup/reorder-item.tpl');
        die;
    }
}
