<?php
/**
 * i-doit
 *
 * Two Factor Authentication
 *
 * @package    i-doit
 * @subpackage General
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

use idoit\Module\UserSettings\Controller\TfaController;
use Symfony\Component\HttpFoundation\Request;

try {
    $session = isys_application::instance()->container->get('session');
    $tfa = isys_application::instance()->container->get('tfa');

    if ($session->is_logged_in() && $tfa->needsVerification()) {
        if ($_SERVER['REQUEST_URI'] === isys_application::instance()->container->get('route_generator')->generate('tfa.verify')) {
            (new TfaController())->verify(new Request([], ['code' => $_POST['code']]))->send();
            die;
        }

        isys_application::instance()->container->get('template')
            ->assign('tfa', $tfa)
            ->display(__DIR__ . '/../../../../themes/default/smarty/main.tpl');
        die;
    }
} catch (\Throwable $e) {

}
