<?php

/**
 * i-doit
 *
 * Smarty plugin for breadcrumb navigation.
 *
 * @internal
 * @package     i-doit
 * @subpackage  Smarty_Plugins
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_smarty_plugin_breadcrumb_navi extends isys_smarty_plugin_f implements isys_smarty_plugin
{
    /**
     * Defines wheather the sm2 meta map is enabled or not.
     *
     * @return  boolean
     */
    public function enable_meta_map()
    {
        return false;
    }

    /**
     * Shows the hierarchical breadcrumb navigation.
     *
     * @param   isys_component_template $p_tplclass
     * @param   array                   $p_params
     *
     * @return  string
     */
    public function navigation_view(isys_component_template $p_tplclass, $p_params = null)
    {
        global $g_comp_session;

        if (!$g_comp_session->is_logged_in()) {
            return "Login";
        }

        if ($p_params === null) {
            $p_params = $this->m_parameter;
        }

        if (!empty($p_params["p_strValue"])) {
            $p_params["p_strValue"] = isys_glob_html_entity_decode(stripslashes($p_params["p_strValue"]));
        }

        $this->m_strPluginClass = "breadcrumb_navi";
        $this->m_strPluginName = $p_params["name"];

        $breadcrumbHtml = (new isys_component_template_breadcrumb)
            ->includeHome(isset($p_params['p_home']) && $p_params['p_home'])
            ->process((bool)$p_params["p_plain"], $p_params["p_append"] ?? null, null, $p_params["p_prepend"] ?? null);

        $l_output = stripslashes($breadcrumbHtml);

        // have to use substr instead of rtrim. Reason rtrim('<li>Global</li>', '</li>') = '<li>Globa'.
        if (substr($l_output, -(strlen($p_params["p_append"])), strlen($l_output)) == $p_params["p_append"]) {
            $l_output = substr($l_output, 0, -(strlen($p_params["p_append"])));
        }

        return $l_output;
    }

    /**
     * Wrapper for the navigation_view.
     *
     * @param   isys_component_template $p_tplclass
     * @param   array                   $p_params
     *
     * @return  string
     */
    public function navigation_edit(isys_component_template $p_tplclass, $p_params = null)
    {
        return $this->navigation_view($p_tplclass, $p_params);
    }
}
