<?php

/**
 * i-doit
 *
 * UI: global category for Remote Management Controller
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_ui_category_g_rm_controller extends isys_cmdb_ui_category_global
{
    /**
     * @param isys_cmdb_dao_category $categoryDao
     *
     * @return void
     * @throws Exception
     */
    private function getPrimaryUrl(isys_cmdb_dao_category $categoryDao)
    {
        if ($_GET['get_primary_url'] && $_GET['ajax']) {
            $l_output = $categoryDao->dynamic_property_callback_remote_url(['isys_connection__isys_obj__id' => $_POST['rmc_object']]);
            if ($l_output !== null) {
                echo $l_output;
            } else {
                echo isys_application::instance()->container->get('language')
                    ->get('LC__CMDB__CATG__RM_CONTROLLER__NO_PRIMARY_URL_DEFINED');
            }
            die;
        }
    }

    /**
     * Process method for displaying the template.
     *
     * @global  array                                  $index_includes
     *
     * @param   isys_cmdb_dao_category_g_rm_controller & $p_cat
     *
     * @author  Van Quyen Hoang <qhoang@i-doit.org>
     */
    public function process(isys_cmdb_dao_category $p_cat)
    {
        $this->getPrimaryUrl($p_cat);

        // Initializing some variables.
        $l_rules = [];
        $l_catdata = $p_cat->get_general_data($p_cat);

        // We let the system fill our form-fields.
        $this->fill_formfields($p_cat, $l_rules, $l_catdata);

        $l_primary_url = isys_cmdb_dao_category_g_access::instance($p_cat->get_database_component())
            ->dynamic_property_callback_primary_url(['isys_obj__id' => $l_catdata['isys_connection__isys_obj__id']]);

        $l_rules["C__CATG__RM_CONTROLLER__ASSIGNED_OBJECT"]["p_strSelectedID"] = $l_catdata['isys_connection__isys_obj__id'];
        $l_rules['C__CATG__RM_CONTROLLER__PRIMARY_URL_READONLY']['p_strValue'] = ($_POST[C__GET__NAVMODE]) ? $l_primary_url : isys_helper_link::handle_url_variables(
            $l_primary_url,
            $l_catdata['isys_connection__isys_obj__id']
        );

        $getParams = $_GET;

        unset($getParams[C__CMDB__GET__VIEWMODE]);
        $getParams[C__GET__AJAX_CALL] = 'category';
        $getParams[C__GET__AJAX] = 1;
        $getParams['get_primary_url'] = 1;
        $getParams[C__CMDB__GET__CATLEVEL] = $l_catdata['isys_catg_rm_controller_list__id'];

        $l_link = '?' . http_build_query($getParams, null, '&');

        $this->get_template_component()
            ->assign('rm_controller_ajax_url', $l_link);
        // Apply rules.
        $this->get_template_component()
            ->smarty_tom_add_rules("tom.content.bottom.content", $l_rules);
    }

    public function process_list(
        isys_cmdb_dao_category &$p_cat,
        $p_get_param_override = null,
        $p_strVarName = null,
        $p_strTemplateName = null,
        $p_bCheckbox = true,
        $p_bOrderLink = true,
        $p_db_field_name = null
    ) {
        $this->getPrimaryUrl($p_cat);

        $deleteRight = isys_auth_cmdb::instance()
            ->has_rights_in_obj_and_category(isys_auth::DELETE, $_GET[C__CMDB__GET__OBJECT], $p_cat->get_category_const());

        isys_component_template_navbar::getInstance()
            ->set_visible(false, C__NAVBAR_BUTTON__ARCHIVE)
            ->set_active(false, C__NAVBAR_BUTTON__ARCHIVE)
            ->set_visible(false, C__NAVBAR_BUTTON__QUICK_PURGE)
            ->set_active(false, C__NAVBAR_BUTTON__QUICK_PURGE)
            ->set_visible($deleteRight, C__NAVBAR_BUTTON__PURGE)
            ->set_active($deleteRight, C__NAVBAR_BUTTON__PURGE);

        return parent::process_list(
            $p_cat,
            $p_get_param_override,
            $p_strVarName,
            $p_strTemplateName,
            $p_bCheckbox,
            $p_bOrderLink,
            $p_db_field_name
        ); // TODO: Change the autogenerated stub
    }

}
