<?php

namespace idoit\Module\Pro\SettingPage\CategoryFolders;

use idoit\Module\System\SettingPage\SettingPage;
use isys_application;
use isys_application as App;
use isys_auth;
use isys_component_template_navbar;
use isys_helper_link;
use isys_module_pro as ModulePro;
use isys_module_system as ModuleSystem;

class CategoryFolders extends SettingPage
{
    /**
     * @param $navMode
     *
     * @return void
     * @throws \Exception
     */
    public function renderPage($navMode)
    {
        $navBar = isys_component_template_navbar::getInstance();
        $navBar->hide_all_buttons();
        $navBar->append_button('LC__CMDB__TREE__SYSTEM__CMDB_CONFIGURATION__QCW', 'link-to-qcw', [
            'tooltip'             => 'LC__CMDB__TREE__SYSTEM__CMDB_CONFIGURATION__LINK_TO_QCW',
            'icon'                => 'axialis/basic/magic-wand.svg',
            'icon_inactive'       => 'axialis/basic/magic-wand.svg',
            'url'                 => isys_helper_link::create_url([
                C__GET__MODULE_ID => C__MODULE__SYSTEM,
                C__GET__MODULE_SUB_ID => C__MODULE__QCW
            ]),
        ]);

        ModuleSystem::getAuth()->check(isys_auth::VIEW, 'category-folders');

        $rules = [
            'C__CATEGORY_FOLDERS__OBJECT_TYPE' => [
                'p_arData' => $this->getObjectTypes()
            ],
            'C__CATEGORY_FOLDERS__REORDER_POPUP' => [
                'p_strPopupType' => 'category_folders_reorder',
                'disableInputGroup' => true
            ],
            'C__CATEGORY_FOLDERS__CREATE_FOLDER_POPUP' => [
                'p_strPopupType' => 'category_folders_create',
                'disableInputGroup' => true
            ],
            'C__CATEGORY_FOLDERS__RESET_POPUP' => [
                'p_strPopupType' => 'category_folders_reset',
                'disableInputGroup' => true
            ]
        ];

        $generator = isys_application::instance()->container->get('route_generator');

        $this->tpl
            ->activate_editmode()
            ->assign('content_title', $this->lang->get('LC__CATEGORY_FOLDERS'))
            ->assign('loadConfigUrl', $generator->generate('pro.category-folders.load-config', ['objectTypeId' => null]))
            ->assign('saveConfigUrl', $generator->generate('pro.category-folders.save-config', ['objectTypeId' => null]))
            ->assign('proWwwDir', ModulePro::getWwwPath())
            ->assign('cssPath', ModulePro::getPath() . 'assets/css/category-folders.css')
            ->assign('canEdit', ModuleSystem::getAuth()->is_allowed_to(isys_auth::EDIT, 'category-folders'))
            ->smarty_tom_add_rule('tom.content.navbar.cRecStatus.p_bInvisible=1')
            ->smarty_tom_add_rules('tom.content.bottom.content', $rules)
            ->include_template('contentbottomcontent', ModulePro::getPath() . 'templates/SettingPage/CategoryFolders/config.tpl');
    }

    /**
     * @return array
     * @throws \Exception
     */
    private function getObjectTypes(): array
    {
        $cmdbDao = App::instance()->container->get('cmdb_dao');
        $objectTypes = [];
        $blockedObjectTypes = [
            'C__OBJTYPE__CONTAINER',
            'C__OBJTYPE__GENERIC_TEMPLATE',
            'C__OBJTYPE__PARALLEL_RELATION',
            'C__OBJTYPE__RELATION',
            'C__OBJTYPE__LOCATION_GENERIC',
            'C__OBJTYPE__MIGRATION_OBJECT'
        ];

        $statusNormal = $cmdbDao->convert_sql_int(C__RECORD_STATUS__NORMAL);
        $blockedConstantList = implode(', ', array_map(fn ($constant) => "'{$constant}'", $blockedObjectTypes));

        $sql = "SELECT isys_obj_type__id AS id, isys_obj_type__title AS title, isys_obj_type__const AS const
            FROM isys_obj_type
            WHERE isys_obj_type__status = {$statusNormal}
            AND isys_obj_type__const NOT IN ({$blockedConstantList})
            AND isys_obj_type__show_in_tree = 1;";

        $result = $cmdbDao->retrieve($sql);
        while($row = $result->get_row()) {
            if (!defined($row['const'])) {
                continue;
            }

            $objectTypes[$row['id']] = $this->lang->get($row['title']);
        }

        return $objectTypes;
    }
}
