[{isys_group name="tom.popup.visualization"}]
<div class="popup-header-ng">
    <h1>[{isys type="lang" ident="LC__CABLE_CONNECTION__POPUP_CONNECTION_CABLE_CONNECTION"}]</h1>
    <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
        <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
    </button>
</div>

<div class="popup-content" style="bottom:35px;">
	<table class="w100" style="table-layout: fixed">
		<colgroup>
			<col style="width:30%;" />
			<col style="width:40%;" />
			<col style="width:30%;" />
		</colgroup>
		[{foreach $cables as $cable}]
			<tr data-connector-a="[{$cable.connA.id}]" data-object-a="[{$cable.connA.objId}]" data-connector-b="[{$cable.connB.id}]" data-object-b="[{$cable.connB.objId}]">
				<td>
					<span class="mouse-help" title="[{isys type="lang" ident=$cable.connA.objTypeTitle}] &raquo; [{$cable.connA.objTitle}] &raquo; [{$cable.connA.connTitle}]">
						[{$cable.connA.connTitle}]
					</span>
				</td>
				<td>[{isys type="f_popup" p_strPopupType="browser_object_ng" name="C__CONNECTION_POPUP__CABLE_`$cable.id`"}]</td>
				<td>
					<span class="mouse-help" title="[{isys type="lang" ident=$cable.connB.objTypeTitle}] &raquo; [{$cable.connB.objTitle}] &raquo; [{$cable.connB.connTitle}]">
						[{$cable.connB.connTitle}]
					</span>
				</td>
			</tr>
		[{/foreach}]
	</table>
</div>

<div class="popup-footer-ng">
	<button type="button" class="btn modal-accept mr5">
		<img src="[{$dir_images}]axialis/basic/symbol-ok.svg" alt="" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]</span>
	</button>

	<button type="button" class="btn modal-closer">
		<img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
	</button>
</div>
[{/isys_group}]

<style>
	#C__CONNECTION_POPUP__CABLE_BROWSER table {
		width: 100%;
		border-spacing: 0;
	}

	#C__CONNECTION_POPUP__CABLE_BROWSER td:first-of-type span,
	#C__CONNECTION_POPUP__CABLE_BROWSER td:last-of-type span {
		line-height: 24px;
		padding: 0 5px;
		width: 100%;
		text-overflow: ellipsis;
		white-space: nowrap;
		overflow: hidden;
		display: block;
	}

	#C__CONNECTION_POPUP__CABLE_BROWSER td {
		padding: 3px 0;
	}

	#C__CONNECTION_POPUP__CABLE_BROWSER tr:nth-child(2n+1) {
		background: #f0f0f0;
	}
</style>