<?php

namespace idoit\Component\ClassLoader;

use Exception;
use idoit\Controller\CatchallController;
use isys_register;

/**
 * i-doit Module Loader
 *
 * @package     i-doit
 * @subpackage  Core
 * @author      atsapko
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class ModuleLoader extends CatchallController
{
    /**
     * @param string        $moduleName
     * @param isys_register $request
     *
     * @throws Exception
     */
    public function boot($moduleName, \isys_register $request)
    {
        $request->module = $moduleName;

        $this->handle($request);
    }
}
