<?php

namespace idoit\Component\Settings;

/**
 * i-doit System setting component
 *
 * @package     idoit\Component
 * @author      atsapko
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

class System extends Settings
{
    /**
     * @param \isys_component_database $db
     *
     * @return System
     */
    public static function factory(\isys_component_database $db): System
    {
        \isys_settings::initialize($db);

        return new self();
    }

    /**
     * @param null   $key
     * @param string $default
     *
     * @return mixed
     */
    public function get($key = null, $default = ''): mixed
    {
        return \isys_settings::get($key, $default);
    }

    /**
     * @param string $key
     * @param mixed  $value
     *
     * @return $this
     */
    public function set($key, $value): static
    {
        \isys_settings::set($key, $value);

        return $this;
    }

    /**
     * @param array $setting
     *
     * @return void
     */
    public function extend($setting): void
    {
        \isys_settings::extend($setting);
    }

    /**
     * @param string $key
     *
     * @return void
     */
    public function remove($key): void
    {
        \isys_settings::remove($key);
    }

    /**
     * @return void
     */
    public function save(): void
    {
        \isys_settings::force_save();
    }
}
