<h2>Step 1: System check</h2>
<table class="stepTable">
    <tr>
        <td colspan="3" class="stepHeadline">
            Operating System
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData" colspan="2">Type: [STEP1_OS_TYPE]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData" colspan="2">Version: [STEP1_OS_VERSION]</td>
    </tr>
    <tr>
        <td></td>
        <td class="stepLineData" colspan="2">
            <a href="https://kb.i-doit.com/en/installation/system-requirements.html#operating-system" target="_blank">Please make sure that your operating system meets the system requirements</a>
        </td>
    </tr>
    <tr>
        <td colspan="3" class="stepHeadline">
            Webserver
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">Version: [STEP1_WEBSERVER_VERSION]</td>
        <td class="[STEP1_WEBSERVER_VERSION_STATUS]">[STEP1_WEBSERVER_VERSION_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP Version: [STEP1_WEBSERVER_PHP]</td>
        <td class="[STEP1_WEBSERVER_PHP_STATUS]">[STEP1_WEBSERVER_PHP_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/curl">cURL</a> Extension: [STEP1_WEBSERVER_PHP_CURL]</td>
        <td class="[STEP1_WEBSERVER_PHP_CURL_STATUS]">[STEP1_WEBSERVER_PHP_CURL_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/gd">GD</a> Extension: [STEP1_WEBSERVER_PHP_GD]</td>
        <td class="[STEP1_WEBSERVER_PHP_GD_STATUS]">[STEP1_WEBSERVER_PHP_GD_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/json">JSON</a> Extension: [STEP1_WEBSERVER_PHP_JSON]</td>
        <td class="[STEP1_WEBSERVER_PHP_JSON_STATUS]">[STEP1_WEBSERVER_PHP_JSON_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/ldap">LDAP</a> Extension: [STEP1_WEBSERVER_PHP_LDAP]</td>
        <td class="[STEP1_WEBSERVER_PHP_LDAP_STATUS]">[STEP1_WEBSERVER_PHP_LDAP_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/libxml">LibXML</a> Extension: [STEP1_WEBSERVER_PHP_LIBXML]</td>
        <td class="[STEP1_WEBSERVER_PHP_LIBXML_STATUS]">[STEP1_WEBSERVER_PHP_LIBXML_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/mbstring">Multibyte String</a> Extension: [STEP1_WEBSERVER_PHP_MBSTRING]</td>
        <td class="[STEP1_WEBSERVER_PHP_MBSTRING_STATUS]">[STEP1_WEBSERVER_PHP_MBSTRING_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/mysqli">MySQLi</a> Extension: [STEP1_WEBSERVER_PHP_MYSQLI]</td>
        <td class="[STEP1_WEBSERVER_PHP_MYSQLI_STATUS]">[STEP1_WEBSERVER_PHP_MYSQLI_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/pcre">PCRE</a> Extension: [STEP1_WEBSERVER_PHP_PCRE]</td>
        <td class="[STEP1_WEBSERVER_PHP_PCRE_STATUS]">[STEP1_WEBSERVER_PHP_PCRE_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/pdo">PDO</a> Extension: [STEP1_WEBSERVER_PHP_PDO]</td>
        <td class="[STEP1_WEBSERVER_PHP_PDO_STATUS]">[STEP1_WEBSERVER_PHP_PDO_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/phar">Phar</a> Extension: [STEP1_WEBSERVER_PHP_PHAR]</td>
        <td class="[STEP1_WEBSERVER_PHP_PHAR_STATUS]">[STEP1_WEBSERVER_PHP_PHAR_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/session">Session</a> Extension: [STEP1_WEBSERVER_PHP_SESSION]</td>
        <td class="[STEP1_WEBSERVER_PHP_SESSION_STATUS]">[STEP1_WEBSERVER_PHP_SESSION_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/simplexml">SimpleXML</a> Extension: [STEP1_WEBSERVER_PHP_SIMPLEXML]</td>
        <td class="[STEP1_WEBSERVER_PHP_SIMPLEXML_STATUS]">[STEP1_WEBSERVER_PHP_SIMPLEXML_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/sockets">Sockets</a> Extension: [STEP1_WEBSERVER_PHP_SOCKETS]</td>
        <td class="[STEP1_WEBSERVER_PHP_SOCKETS_STATUS]">[STEP1_WEBSERVER_PHP_SOCKETS_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/spl">SPL</a> Extension: [STEP1_WEBSERVER_PHP_SPL]</td>
        <td class="[STEP1_WEBSERVER_PHP_SPL_STATUS]">[STEP1_WEBSERVER_PHP_SPL_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/xml">XML</a> Extension: [STEP1_WEBSERVER_PHP_XML]</td>
        <td class="[STEP1_WEBSERVER_PHP_XML_STATUS]">[STEP1_WEBSERVER_PHP_XML_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/zip">ZIP</a> Extension: [STEP1_WEBSERVER_PHP_ZIP]</td>
        <td class="[STEP1_WEBSERVER_PHP_ZIP_STATUS]">[STEP1_WEBSERVER_PHP_ZIP_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP <a target="_blank" href="http://php.net/zlib">ZLIB</a> Extension: [STEP1_WEBSERVER_PHP_ZLIB]</td>
        <td class="[STEP1_WEBSERVER_PHP_ZLIB_STATUS]">[STEP1_WEBSERVER_PHP_ZLIB_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP Setting "<a href="#" onclick="document.getElementById('max_input_vars').style.display='';">max_input_vars</a>":
            [STEP1_MAX_INPUT_VARS]
        </td>
        <td class="[STEP1_MAX_INPUT_VARS_STATUS]">[STEP1_MAX_INPUT_VARS_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">PHP Setting "<a href="#" onclick="document.getElementById('post_max_size').style.display='';">post_max_size</a>":
            [STEP1_POST_MAX_SIZE]
        </td>
        <td class="[STEP1_POST_MAX_SIZE_STATUS]">[STEP1_POST_MAX_SIZE_RESULT]</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">Is URL rewrite active (mod_rewrite)</td>
        <td id="mod_rewrite_test" style="text-align: right">
            <img class="animation-rotate" alt="" src="images/axialis/user-interface/loading.svg" />
        </td>
    </tr>
    <tr>
        <td colspan="3" class="stepHeadline">
            Database Access Interface (PHP MySQL Extension)
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td class="stepLineData">Version: [STEP1_DATABASE_VERSION]</td>
        <td class="[STEP1_DATABASE_VERSION_STATUS]">[STEP1_DATABASE_VERSION_RESULT]</td>
    </tr>
</table>

<div id="max_input_vars" style="display:none;position:absolute;top:230px;left:40%;width:280px;border:1px solid #666; background:#fff; padding:10px;">
    <a href="#" style="float:right;" onclick="document.getElementById('max_input_vars').style.display='none';">Close</a>
    <span>
        You should set max_input_vars to at least <br /><strong>10000</strong> in order to install i-doit.<br />
        <hr />
        php.ini Setting example:
        <pre>max_input_vars = 10000</pre>
    </span>
</div>

<div id="post_max_size" style="display:none;position:absolute;top:260px;left:40%;width:280px;border:1px solid #666; background:#fff; padding:10px;">
    <a href="#" style="float:right;" onclick="document.getElementById('post_max_size').style.display='none';">Close</a>
    <span>
        You should set post_max_size<br />to at least <strong>128M</strong> in order to install i-doit.<br />
        <hr />
        php.ini Setting example:
        <pre>post_max_size = 128M</pre>
    </span>
</div>

<style>
    .animation-rotate {
        animation-name: animateRotation;
        animation-duration: 750ms;
        animation-timing-function: ease-out;
        animation-iteration-count: infinite;
        visibility: visible !important;
    }
    @keyframes animateRotation {
        0% {
            transform: rotate(0deg);
        }
        100% {
            transform: rotate(360deg);
        }
    }
</style>

<script type="text/javascript">
    (function () {
        const $rewriteTestContainer = $('mod_rewrite_test');

        if ($rewriteTestContainer) {
            // @see ID-9680 Implement automatic 'mod rewrite' test via prototype.
            new Ajax.Request('[WWW_DIR]mod-rewrite-test', {
                method: 'get',
                onComplete: (xhr) => {
                    const isJson = xhr.hasOwnProperty('responseJSON')
                        && !Object.isUndefined(xhr.responseJSON)
                        && xhr.responseJSON !== null
                        && !xhr.responseText.blank();

                    if (isJson) {
                        $rewriteTestContainer.writeAttribute('title', xhr.responseJSON.message);
                    }

                    if (xhr.status === 200) {
                        $rewriteTestContainer.addClassName('stepLineStatusGood').update('ACTIVE');
                    } else if (xhr.status === 404) {
                        $rewriteTestContainer.addClassName('stepLineStatusBad').update('NOT ACTIVE');
                    } else {
                        $rewriteTestContainer.addClassName('stepLineStatusBoth').update('HTTP STATUS ' + xhr.status);
                    }
                }
            });
        }
    })();
</script>
