<?php

namespace idoit\Module\Console\Console\Command\Addon;

use idoit\Module\Console\Console\Command\AbstractConfigurableCommand;
use idoit\Module\Console\Option\Option;
use idoit\Module\Console\Option\PasswordOption;
use idoit\Module\Console\Steps\Addon\AddonUninstall;
use idoit\Module\Console\Steps\AuthorisationStep;
use idoit\Module\Console\Steps\CollectionStep;
use Symfony\Component\Console\Input\InputOption;

class UninstallAddonCommand extends AbstractConfigurableCommand
{
    /**
     * Pre configure child commands
     */
    protected function configure()
    {
        global $g_absdir;
        global $g_db_system;
        if (!is_array($g_db_system)) {
            die("config.inc.php is not loaded! Please, install i-doit first!\n");
        }

        $this->setName('addon-uninstall')
            ->setDescription('Deactivate add-on')
            ->setHelp('Uninstalls an add-on');

        $this->addValue(new Option('system.user', 'i-doit Admin Username', 'admin', new InputOption('user', 'u', InputOption::VALUE_REQUIRED, 'i-doit Admin username')));
        $this->addValue(new PasswordOption(
            'system.password',
            'i-doit Admin Password',
            null,
            new InputOption('password', 'p', InputOption::VALUE_OPTIONAL, 'i-doit Admin password'),
            false
        ));
        $this->addValue(new Option('addon', 'Add-on identifier', null, new InputOption('addon', 'a', InputOption::VALUE_REQUIRED, 'Add-on identifier')));

        parent::configure();
    }

    /**
     * @throws \isys_exception_database
     */
    protected function createStep()
    {
        return new CollectionStep('Uninstall add-on', [
            new AuthorisationStep($this->getValue('system.user'), $this->getValue('system.password')),
            new AddonUninstall($this->getValue('addon'))
        ]);
    }
}
