<?php

namespace idoit\Module\Console\Steps\Addon;

use idoit\Module\Console\Steps\Message\ErrorLevel;
use idoit\Module\Console\Steps\Message\Messages;
use idoit\Module\Console\Steps\Message\StepMessage;
use idoit\Module\Console\Steps\Step;
use Symfony\Component\Filesystem\Filesystem;

class CleanupAfterBundleInstallation implements Step
{
    /** @var string  */
    private string $path;

    /**
     * CleanupAfterBundleInstallation constructor.
     *
     * @param string $path
     */
    public function __construct(string $path)
    {
        $this->path = $path;
    }

    /**
     * Get name of the step
     *
     * @return string
     */
    public function getName()
    {
        return 'Clean up';
    }

    /**
     * Process the work
     *
     * @param Messages $messages
     *
     * @return mixed
     */
    public function process(Messages $messages)
    {

        $filesystem = new Filesystem();

        if (is_dir($this->path)) {
            // Once all add-on related files where copied, copy the rest from the temporary directory.
            $messages->addMessage(new StepMessage($this, 'Move leftover files', ErrorLevel::INFO));
            $filesystem->mirror($this->path, BASE_DIR);

            // Delete any add-on remains.
            $messages->addMessage(new StepMessage($this, 'Remove temporary directory', ErrorLevel::INFO));
            $filesystem->remove($this->path);
        }

        return true;
    }
}
