<?php
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Module\Console\Steps\Sql;

use idoit\Module\Console\Steps\Step;
use mysqli;

abstract class SqlStep implements Step
{
    private $host;

    private $name;

    private $password;

    private $port;

    private $username;

    const POSSIBLE_LOCAL_HOSTS = [
        'localhost',
        '127.0.0.1',
        '::1'
    ];

    /**
     * @return mixed
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return mixed
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @return mixed
     */
    public function getPort()
    {
        return $this->port;
    }

    /**
     * @return mixed
     */
    public function getUsername()
    {
        return $this->username;
    }

    public function __construct(
        $host,
        $username,
        $password,
        $name,
        $port
    ) {
        $this->host = $host;
        $this->username = $username;
        $this->password = $password;
        $this->name = $name;
        $this->port = $port;
    }

    protected function createConnection()
    {
        return new mysqli($this->host, $this->username, $this->password, $this->name, $this->port);
    }

    /**
     * @return string
     */
    public function getHostForUser()
    {
        $grantHost = '%';
        if (in_array($this->host, self::POSSIBLE_LOCAL_HOSTS)) {
            $grantHost = 'localhost';
        }

        return $grantHost;
    }
}
