<?php

use idoit\Module\CustomFields\Controller\Ajax;
use idoit\Module\CustomFields\Controller\ChangeIconController;
use idoit\Module\CustomFields\Controller\TechnicalConfigurationController;
use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return function (RoutingConfigurator $routes) {
    $routes->add('custom_fields.ajax.find-property-by-key', '/custom-fields/ajax/find-property-by-key')
        ->methods(['GET'])
        ->controller([Ajax::class, 'findPropertyByKey']);

    $routes->add('custom_fields.ajax.load', '/custom-fields/ajax/load/{id}')
        ->methods(['GET'])
        ->requirements(['id' => '\d+'])
        ->controller([Ajax::class, 'loadConfiguration']);

    $routes->add('custom_fields.ajax.save', '/custom-fields/ajax/save/{id}')
        ->methods(['POST'])
        ->requirements(['id' => '\d+'])
        ->controller([Ajax::class, 'saveConfiguration']);

    $routes->add('custom_fields.modal.load-technical-configuration', '/custom-fields/modal/load-technical-configuration/{id}')
        ->methods(['GET'])
        ->requirements(['id' => '\d+'])
        ->controller([TechnicalConfigurationController::class, 'modal']);

    $routes->add('custom_fields.modal.change-icon', '/custom-fields/modal/change-icon')
        ->methods(['GET'])
        ->controller([ChangeIconController::class, 'modal']);
};
