<?php

/**
 * CMDB Explorer view
 *
 * @package     i-doit
 * @subpackage  CMDB_Views
 * @author      Dennis Stücken <dstuecken@i-doit.de>
 * @author      Leonard Fischer <lfischer@i-doit.de>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_view_explorer extends isys_cmdb_view
{
    /**
     * @return  integer
     */
    public function get_id()
    {
        return C__CMDB__VIEW__EXPLORER;
    }

    /**
     * @param  array &$l_gets
     */
    public function get_mandatory_parameters(&$l_gets)
    {
        $l_gets = [];
    }

    /**
     * @return  string
     */
    public function get_name()
    {
        return isys_application::instance()->container->get('language')
            ->get('LC__MODULE__CMDB__VISUALIZATION');
    }

    /**
     * @param  array &$l_gets
     */
    public function get_optional_parameters(&$l_gets)
    {
        $l_gets = [];
    }

    /**
     * @param  integer $p_navmode
     */
    public function handle_navmode($p_navmode)
    {
        ;
    }

    /**
     *
     */
    public function process()
    {
        isys_auth_cmdb::instance()
            ->check(isys_auth::VIEW, 'EXPLORER');

        $this->init();
    }

    /**
     * Inititialize this view
     */
    private function init()
    {
        // @see ID-10766 Fix potential XSS vulnerability.
        $view = $_GET[C__CMDB__VISUALIZATION_VIEW] === C__CMDB__VISUALIZATION_VIEW__IT_SERVICE
            ? C__CMDB__VISUALIZATION_VIEW__IT_SERVICE
            : C__CMDB__VISUALIZATION_VIEW__OBJECT;
        $type = isset($_GET[C__CMDB__VISUALIZATION_TYPE]) && $_GET[C__CMDB__VISUALIZATION_TYPE] === C__CMDB__VISUALIZATION_TYPE__GRAPH
            ? C__CMDB__VISUALIZATION_TYPE__GRAPH
            : C__CMDB__VISUALIZATION_TYPE__TREE;

        // If the given type does not exist, simply use the "tree".
        if (!class_exists('isys_visualization_' . $type)) {
            $type = C__CMDB__VISUALIZATION_TYPE__TREE;
        }

        isys_factory::get_instance('isys_visualization_' . $type, isys_module_request::get_instance())
            ->init([C__CMDB__VISUALIZATION_VIEW => $view])
            ->start();
    }
}
