<?php
/**
 * CMDB Status Handler.
 *
 * @package     i-doit
 * @subpackage  General
 * @author      Dennis Stuecken <dstuecken@synetics.de>
 * @version     0.9
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

// ITIL Status.
$l_status = [0 => ''];

$database = isys_application::instance()->container->get('database');
$language = isys_application::instance()->container->get('language');

$l_dao_cmdb = new isys_cmdb_dao_status($database);

$l_status_dao = $l_dao_cmdb->get_cmdb_status();

while ($l_row = $l_status_dao->get_row()) {
    // @see ID-6464 Display all CMDB-Status but "i-doit status".
    if ($l_row['isys_cmdb_status__const'] === 'C__CMDB_STATUS__IDOIT_STATUS') {
        continue;
    }

    $l_status[$l_row['isys_cmdb_status__id']] = $language->get($l_row['isys_cmdb_status__title']);
}

asort($l_status);

isys_application::instance()->container->get('template')
    ->assign('www_dir', $g_config['www_dir'])
    ->assign('cmdb_status', $l_status);
