<div id="attribute-settings-popup_add">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__SELECT_ATTRIBUTE"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content ">
        <div class="search-bar">
            <input type="text" class="input input-block" placeholder="[{isys type="lang" ident="LC__UNIVERSAL__SEARCH"}]" />
            <img src="[{$dir_images}]axialis/basic/zoom.svg" alt="" />
        </div>

        <div class="display-flex" style="height: calc(100% - 80px);">
            <div class="category-list">
                <h2>[{isys type="lang" ident="LC_UNIVERSAL__CATEGORY"}]</h2>

                <div class="loading-indicator">
                    <img src="[{$dir_images}]axialis/user-interface/loading.svg" class="animation-rotate mr5" alt="" />
                    <span>[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]</span>
                </div>

                <ul class="list">
                    <!-- To be filled by JS -->
                </ul>
            </div>

            <div class="attribute-list">
                <div class="loading-indicator hide">
                    <img src="[{$dir_images}]axialis/user-interface/loading.svg" class="animation-rotate mr5" alt="" />
                    <span>[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]</span>
                </div>

                <div class="empty-indicator hide">
                    <span>[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__FOUND_NO_ATTRIBUTES"}]</span>
                </div>

                <div class="list-container">
                    <!-- To be filled by JS -->
                </div>
            </div>
        </div>
    </div>

    <div class="popup-footer">
        <button type="button" class="btn save-button">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" alt="" /><span>[{isys type="lang" ident="LC__NAVIGATION__NAVBAR__SAVE"}]</span>
        </button>

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>
<script type="text/javascript">
    (function () {
        'use strict';

        const $popup = $('attribute-settings-popup_add');
        const $saveButton = $popup.down('.save-button');

        // Do not submit the form if someone tries to check a checkbox with the 'Enter' key.
        $popup.on('keydown', function (ev) {
            // Prevent form submit. We could also use the 'preventAccidentalFormSubmit()' function for this, but we have specific logic.
            if (ev.keyCode === Event.KEY_RETURN) {
                const $checkbox = ev.findElement('input[type="checkbox"]');

                if ($checkbox) {
                    $checkbox.simulate('click');
                }

                ev.preventDefault();
            }
        });

        idoit.Translate.set('LC__ATTRIBUTE_SETTINGS__ADDED', '[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__ADDED"}]');
        idoit.Translate.set('LC__ATTRIBUTE_SETTINGS__SYSTEM_ATTRIBUTE', '[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__SYSTEM_ATTRIBUTE"}]');
        idoit.Translate.set('LC__ATTRIBUTE_SETTINGS__ALL_ATTRIBUTES', '[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__ALL_ATTRIBUTES"}]');

        $popup.on('click', '.popup-closer', function () {
            popup_close();
        });

        idoit.Require
            .addModule('attribute-settings.attribute-selection', '[{$wwwPath}]assets/js/AttributeSelection.js')
            .require('attribute-settings.attribute-selection', function () {
                const attributeSelection = new AttributeSelection(
                    $popup.down('.category-list .list'),
                    $popup.down('.category-list .loading-indicator'),
                    $popup.down('.search-bar'),
                    $popup.down('.attribute-list .loading-indicator'),
                    $popup.down('.attribute-list .empty-indicator'),
                    $popup.down('.attribute-list .list-container'),
                    { loadAttributesUrl: '[{$loadAttributesUrl}]' });

                attributeSelection.loadData();

                $saveButton.on('click', function () {
                    $saveButton.disable()
                        .down('img')
                        .addClassName('animation-rotate')
                        .writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg');

                    new Ajax.Request('[{$createAttributeSettingUrl}]', {
                        method:     'post',
                        parameters: {
                            properties: JSON.stringify(attributeSelection.getCheckedItems())
                        },
                        onComplete: function (xhr) {
                            if (!is_json_response(xhr, true)) {
                                return;
                            }

                            const json = xhr.responseJSON;

                            if (!json.success) {
                                idoit.Notify.error(json.message, {sticky: true});

                                $saveButton.down('img')
                                    .removeClassName('animation-rotate')
                                    .writeAttribute('src', window.dir_images + 'axialis/basic/symbol-ok.svg');

                                return;
                            }

                            idoit.Notify.success('[{isys type="lang" ident="LC__ATTRIBUTE_SETTINGS__CREATED_NOTIFICATION"}]');

                            popup_close();

                            setTimeout(function () {
                                document.location.reload();
                            }, 500);
                        }
                    });
                });
            });
    })();
</script>
