[{isys_group name="tom.popup.category-folders.create-folder"}]
<div id="category-folders-popup_create-folder">
    <div class="modal-header">
        <h1>[{isys type="lang" ident=$popupHeadline}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="modal-content p5">
        <table class="contentTable">
            <tr class="hide">
                <td></td>
                <td>[{isys type="f_text" name="C__CATEGORY_FOLDERS__FOLDER_ID"}]</td>
            </tr>
            <tr>
                <td class="key">[{isys type="f_label" name="C__CATEGORY_FOLDERS__FOLDER_NAME" ident="LC__CATEGORY_FOLDERS__FOLDER_NAME"}]</td>
                <td class="value">
                    [{isys type="f_text" name="C__CATEGORY_FOLDERS__FOLDER_NAME"}]
                    <p class="cb pl20 pt5 text-neutral-600">[{isys type="lang" ident="LC__CATEGORY_FOLDERS__FOLDER_NAME_DESCRIPTION"}]</p>
                </td>
            </tr>
            <tr>
                <td class="key">[{isys type="f_label" name="C__CATEGORY_FOLDERS__FOLDER_LOCATION" ident="LC__CATEGORY_FOLDERS__FOLDER_LOCATION"}]</td>
                <td class="value pl20">[{isys name="C__CATEGORY_FOLDERS__FOLDER_LOCATION" type="f_popup"}]</td>
            </tr>
        </table>
    </div>

    <div class="modal-footer">
        <button type="button" class="btn save-button mr5">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_SAVE"}]</span>
        </button>
        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        "use strict";

        const $popup = $('category-folders-popup_create-folder');
        const $saveButton = $popup.down('.save-button');
        const $folderNameInput = $('C__CATEGORY_FOLDERS__FOLDER_NAME');
        const $folderLocationField = $('C__CATEGORY_FOLDERS__FOLDER_LOCATION_FIELD');
        const $folderLocationHidden = $('C__CATEGORY_FOLDERS__FOLDER_LOCATION_HIDDEN');
        const $folderLocationRootCheckbox = $('C__CATEGORY_FOLDERS__FOLDER_LOCATION_ROOT_CHECKBOX');

        $folderNameInput.focus();

        preventAccidentalFormSubmit($popup);

        $popup.on('click', '.popup-closer', function () {
            Modal.close($popup.up('.modal'));
        });

        $folderLocationHidden.on('value:updated', function () {
            const parent = JSON.parse($folderLocationHidden.getValue());

            $folderLocationField.setValue(parent.folderName);

            // Remove the 'folderName' because it might contain UTF8 characters that will cause errors when sent to the backend.
            delete parent.folderName;

            $folderLocationHidden.setValue(JSON.stringify(parent));

            if (parent.isRoot) {
                $folderLocationRootCheckbox.setValue(1);
                $folderLocationRootCheckbox.disable();
            } else {
                $folderLocationRootCheckbox.enable();
                $folderLocationRootCheckbox.setValue(0);
            }
        });

        $saveButton.on('click', function () {
           // First we need to go sure that the name is filled:
            const folderName = $folderNameInput.getValue();

            if (folderName.blank()) {
                idoit.Notify.error('[{isys type="lang" ident="LC__CATEGORY_FOLDERS__FOLDER_NAME_VALIDATION"}]');
                return;
            }

            const folderId = +$F('C__CATEGORY_FOLDERS__FOLDER_ID');
            const parent = JSON.parse($folderLocationHidden.getValue());

            new Ajax.Request('[{$folderUrl}]', {
                method:     'post',
                parameters: {
                    'folderId': folderId,
                    'parentId': parent.folderId,
                    'configId': parseInt('[{$configId}]'),
                    'name':     folderName.trim()
                },
                onComplete:  function (xhr) {
                    if (!is_json_response(xhr, true)) {
                        return;
                    }

                    const json = xhr.responseJSON;

                    if (!json.success) {
                        idoit.Notify.error(json.message, { sticky: true });
                        return;
                    }

                    // @see ID-9531 Reload the structure, when a folder was created successfully.
                    if ($('category-tree')) {
                        $('category-tree').fire('reload:structure')
                    }

                    if (folderId > 0) {
                        idoit.Notify.success('[{isys type="lang" ident="LC__CATEGORY_FOLDERS__FOLDER_UPDATED"}]');
                    } else {
                        idoit.Notify.success('[{isys type="lang" ident="LC__CATEGORY_FOLDERS__FOLDER_CREATED"}]');
                    }
                    Modal.close($popup.up('.modal'));
                }
            });
        });
    })();
</script>
[{/isys_group}]
