<?php

use idoit\Module\Qrcode\Controller\BarcodeController;
use idoit\Module\Qrcode\Controller\ImageController;
use idoit\Module\Qrcode\Controller\QrCodeController;
use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return function (RoutingConfigurator $routes) {
    $routes->add('qrcode.image.object', '/qrcode/{objectId}')
        ->methods(['GET'])
        ->requirements(['objectId' => '\d+'])
        ->controller([ImageController::class, 'getObjectQrCode']);

    $routes->add('qrcode.modal.object', '/qrcode-modal/{objectId}')
        ->methods(['GET'])
        ->requirements(['objectId' => '\d+'])
        ->controller([QrCodeController::class, 'getModal']);

    $routes->add('barcode.image.object', '/barcode/{objectId}')
        ->methods(['GET'])
        ->requirements(['objectId' => '\d+'])
        ->controller([ImageController::class, 'getObjectBarcode']);

    $routes->add('barcode.modal.object', '/barcode-modal/{objectId}')
        ->methods(['GET'])
        ->requirements(['objectId' => '\d+'])
        ->controller([BarcodeController::class, 'getModal']);
};
