<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     Modules
 * @subpackage  QCW
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_quick_configuration_wizard_autoload extends isys_module_manager_autoload
{
    /**
     * @param  string $className
     *
     * @return bool
     */
    public static function init($className)
    {
        $addOnPath = '/src/classes/modules/quick_configuration_wizard/';
        $classMap = [
            'isys_quick_configuration_wizard_dao'             => 'dao/isys_quick_configuration_wizard_dao.class.php',
            'isys_module_quick_configuration_wizard'          => 'isys_module_quick_configuration_wizard.class.php',
            'isys_module_quick_configuration_wizard_autoload' => 'isys_module_quick_configuration_wizard_autoload.class.php',
            'isys_ajax_handler_quick_configuration_wizard'    => 'ajax/isys_ajax_handler_quick_configuration_wizard.class.php',
            'isys_popup_qcw_adjust_object_type'               => 'src/popup/isys_popup_qcw_adjust_object_type.class.php',
            'isys_popup_qcw_adjust_category'                  => 'src/popup/isys_popup_qcw_adjust_category.class.php',
            'isys_popup_qcw_adjust'                           => 'src/popup/isys_popup_qcw_adjust.class.php',
            'isys_popup_qcw_profiles'                         => 'src/popup/isys_popup_qcw_profiles.class.php',
            'isys_popup_qcw_adjust_object_type_group'         => 'src/popup/isys_popup_qcw_adjust_object_type_group.class.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($addOnPath . $classMap[$className])) {
            isys_cache::keyvalue()->ns('autoload')->set($className, $addOnPath . $classMap[$className]);

            return true;
        }

        return false;
    }
}
