<?php

namespace idoit\Module\Report\SqlQuery\Condition\Comparison;

use idoit\Module\Report\SqlQuery\Condition\ConditionType;
use idoit\Module\Report\SqlQuery\Condition\ConditionTypeInterface;

/**
 * @package     i-doit
 * @subpackage  Core
 * @author      Van Quyen Hoang <qhoang@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class InCondition extends ConditionType implements ConditionTypeInterface
{
    /**
     * @return bool
     */
    public function isApplicable()
    {
        return ((is_array($this->getConditionValue()) || strpos($this->getConditionValue(), ',') !== false) && $this->getConditionComparison() === '=');
    }

    /**
     * @return string
     */
    public function format()
    {
        if ($this->getConditionValue()) {
            $condition = ' ' . $this->getConditionField() . ' IN (' . (is_array($this->getConditionValue()) ? implode(',', $this->getConditionValue()) : $this->getConditionValue()) . ') ';
        } else {
            $condition = ' ' . $this->getConditionField() . ' IS NULL ';
        }

        return $condition;
    }
}
