<?php

namespace idoit\Module\Report\SqlQuery\Condition\Comparison;

use idoit\Module\Report\SqlQuery\Condition\ConditionType;
use idoit\Module\Report\SqlQuery\Condition\ConditionTypeInterface;

/**
 * @package     i-doit
 * @subpackage  Core
 * @author      Van Quyen Hoang <qhoang@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class NullCondition extends ConditionType implements ConditionTypeInterface
{
    /**
     * @return bool
     */
    public function isApplicable()
    {
        return (empty($this->getConditionValue()) && strtoupper($this->getConditionComparison()) === 'IS NULL');
    }

    /**
     * @return string
     */
    public function format()
    {
        return ' (' . $this->getConditionField() . ' IS NULL OR ' . $this->getConditionField() . ' = \'\' )';
    }
}
