<div>
    <div class="p10">
        <table class="contentTable">
            <tr>
                <td class="key">[{isys type="f_label" name="C__CMDB_CHANGES__PERIOD" ident="LC__REPORT__VIEW__CMDB_CHANGES__PERIOD"}]</td>
                <td class="value">
                    [{isys type="f_popup" name="C__CMDB_CHANGES__PERIOD_FROM" p_strPopupType="calendar"}]
	                [{isys type="f_popup" name="C__CMDB_CHANGES__PERIOD_TO" p_strPopupType="calendar"}]
                </td>
            </tr>
            <tr>
                <td class="key">[{isys type="f_label" name="C__CMDB_CHANGES__PERSONS" ident="LC__REPORT__VIEW__CMDB_CHANGES__PERSONS"}]</td>
                <td class="value">
                    [{isys
                        type="f_popup"
                        name="C__CMDB_CHANGES__PERSONS"
                        p_strPopupType="browser_object_ng"}]
                </td>
            </tr>
            <tr>
                <td class="key">[{isys type="f_label" name="C__CMDB_CHANGES__OBJECTS" ident="LC__REPORT__VIEW__CMDB_CHANGES__OBJECTS"}]</td>
                <td class="value">
                    [{isys
                        type="f_popup"
                        name="C__CMDB_CHANGES__OBJECTS"
                        p_strPopupType="browser_object_ng"}]
                </td>
            </tr>
            <tr>
                <td></td>
                <td>
                    <button type="button" id="data-loader" class="btn ml20">
	                    <img src="[{$dir_images}]axialis/development/process.svg" /><span>[{isys type="lang" ident="LC__UNIVERSAL__LOAD"}]</span>
                    </button>
                </td>
            </tr>
        </table>
    </div>

    <div class="bg-neutral-200 p5 border-top border-bottom display-flex align-items-center" style="height: 42px">
        <h2>[{isys type="lang" ident="LC__UNIVERSAL__RESULT"}]</h2>
    </div>

    <div id="report_view_cmdb_changes_result" class="mt20"></div>
</div>

<script type="text/javascript">
(function () {
	"use strict";

	var $button = $('data-loader');

    $button.on('click', function () {
        $button
            .down('img').writeAttribute('src', '[{$dir_images}]axialis/user-interface/loading.svg').addClassName('animation-rotate')
            .next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

        new Ajax.Request('[{$ajax_url}]', {
            method:     'post',
            parameters: {
                'C__CMDB_CHANGES__PERIOD_FROM__HIDDEN': $F('C__CMDB_CHANGES__PERIOD_FROM__HIDDEN'),
                'C__CMDB_CHANGES__PERIOD_TO__HIDDEN':   $F('C__CMDB_CHANGES__PERIOD_TO__HIDDEN'),
                'C__CMDB_CHANGES__PERSONS__HIDDEN':     $F('C__CMDB_CHANGES__PERSONS__HIDDEN'),
                'C__CMDB_CHANGES__OBJECTS__HIDDEN':     $F('C__CMDB_CHANGES__OBJECTS__HIDDEN')
            },
            onComplete: function (xhr) {
                $button
                    .down('img').writeAttribute('src', '[{$dir_images}]axialis/development/process.svg').removeClassName('animation-rotate')
                    .next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOAD"}]');

                if (!is_json_response(xhr, true)) {
                    return;
                }

                const json = xhr.responseJSON;

                if (!json.success) {
                    $('report_view_cmdb_changes_result')
                        .update(new Element('p', { className: 'm20 p10 box-blue display-flex align-items-center' })
                            .update(new Element('img', { src: window.dir_images + 'axialis/basic/button-info.svg', className: 'mr10' }))
                            .insert(new Element('span').update(json.message)));
                    return
                }

                var ajax_pager         = false,
                    ajax_pager_url     = '',
                    ajax_pager_preload = 0,
                    max_pages          = 0,
                    page_limt          = '[{$page_limit}]',
                    name               = 'report_view_cmdb_changes_result';

                window.currentReportView = new Lists.Objects(name, {
                    max_pages:          max_pages,
                    ajax_pager:         ajax_pager,
                    ajax_pager_url:     ajax_pager_url,
                    ajax_pager_preload: ajax_pager_preload,
                    data:               json.data,
                    filter:             'top',
                    paginate:           'top',
                    pageCount:          page_limt,
                    draggable:          false,
                    checkboxes:         false
                });

            }
        });
    });
}());
</script>
