<?php

/**
 * i-doit Report Manager View
 *
 * @package     i-doit
 * @subpackage  Reports
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   Copyright 2011 - synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_report_view_layer2_nets extends isys_report_view
{
    /**
     * @return string
     */
    public static function name()
    {
        return 'LC__REPORT__VIEW__LAYER2_NETS__TITLE';
    }

    /**
     * @return string
     */
    public static function description()
    {
        return 'LC__REPORT__VIEW__LAYER2_NETS__DESCRIPTION';
    }

    /**
     * @return string
     */
    public function template()
    {
        return __DIR__ . '/view_layer2_nets.tpl';
    }

    /**
     * @return string
     */
    public static function viewtype()
    {
        return 'LC__CMDB__OBJTYPE__RELATION';
    }

    /**
     * @todo  Better use (one?) "report specific" query than relying on multiple DAOs and their returned values
     */
    public function start()
    {
        // Preparing some variables.
        $rawData = [];
        $preparedFrontendData = [];

        // Initializing the DAO's.
        $cmdbDao = isys_cmdb_dao::instance($this->database);
        $layer2AssignedPortDao = isys_cmdb_dao_category_s_layer2_net_assigned_ports::instance($this->database);
        $portDao = isys_cmdb_dao_category_g_network_port::instance($this->database);
        $layer3NetDao = isys_cmdb_dao_category_s_net::instance($this->database);
        $hostaddressDao = isys_cmdb_dao_category_g_ip::instance($this->database);

        $empty = isys_tenantsettings::get('gui.empty_value', '-');
        $primary = ' (' . $this->language->get('LC__CATP__IP__PRIMARY') . ')';

        // At first we search all objects of the type "layer2 net".
        $l_obj_res = $cmdbDao->get_objects_by_type(defined_or_default('C__OBJTYPE__LAYER2_NET'));

        // And now the fun begins...
        while ($l_obj_row = $l_obj_res->get_row()) {
            $layer2Link = '<a href="?' . C__CMDB__GET__OBJECT . '=' . $l_obj_row['isys_obj__id'] . '">' . $l_obj_row['isys_obj__title'] . '</a>';

            if (!isset($rawData[$layer2Link])) {
                $rawData[$layer2Link] = [];
            }

            $l_l2_assigned_hosts_res = $layer2AssignedPortDao->get_data(
                null,
                null,
                'AND isys_cats_layer2_net_assigned_ports_list__isys_obj__id = ' . $cmdbDao->convert_sql_id($l_obj_row['isys_obj__id']),
                null,
                C__RECORD_STATUS__NORMAL
            );

            while ($l_l2_assigned_hosts_row = $l_l2_assigned_hosts_res->get_row()) {
                $portName = $portDao->get_data($l_l2_assigned_hosts_row['isys_catg_port_list__id'])->get_row_value('isys_obj__title');

                $layer3Link = $serverLink = '';
                $portLink = $l_l2_assigned_hosts_row['isys_catg_port_list__title'];

                $hostaddressCondition = ' AND isys_catg_ip_list__isys_catg_port_list__id = ' . $hostaddressDao->convert_sql_id($l_l2_assigned_hosts_row['isys_catg_port_list__id']) . ' ';
                $hostaddressData = $hostaddressDao
                    ->get_data(null, null, $hostaddressCondition, null, C__RECORD_STATUS__NORMAL)
                    ->get_row();

                if (!empty($hostaddressData) && $hostaddressData['isys_cats_net_ip_addresses_list__isys_obj__id'] > 0) {
                    $layer3NetRow = $layer3NetDao
                        ->get_data(null, $hostaddressData['isys_cats_net_ip_addresses_list__isys_obj__id'])
                        ->get_row();

                    $layer3Link = '<a href="?' . C__CMDB__GET__OBJECT . '=' . $hostaddressData['isys_cats_net_ip_addresses_list__isys_obj__id'] . '">' .
                        $layer3NetRow['isys_obj__title'] . " ({$layer3NetRow['isys_cats_net_list__address']} / {$layer3NetRow['isys_cats_net_list__cidr_suffix']})" .
                        '</a>';
                }

                if (!empty($l_l2_assigned_hosts_row['isys_catg_port_list__isys_obj__id'])) {
                    $serverLink = '<a href="?' . C__CMDB__GET__OBJECT . '=' . $l_l2_assigned_hosts_row['isys_catg_port_list__isys_obj__id'] . '">' .
                        $portName . " <span>(#{$l_l2_assigned_hosts_row['isys_catg_port_list__isys_obj__id']})</span></a>";
                }

                $ipAddress = ($hostaddressData['isys_cats_net_ip_addresses_list__title'] ?: $empty) .
                    ($hostaddressData['isys_catg_ip_list__primary'] ? $primary : '');

                $rawData[$layer2Link][$portLink][$serverLink][$ipAddress] = $layer3Link;
            }
        }

        // To easily display the data we have to alter the array structure.
        foreach ($rawData as $l_key => $l_item) {
            if (!is_array($l_item) || empty($l_item)) {
                $preparedFrontendData[] = [$l_key];
                continue;
            }

            foreach ($l_item as $l_key2 => $l_item2) {
                if (!is_array($l_item2) || empty($l_item2)) {
                    $preparedFrontendData[] = [$l_key, $l_key2];
                    continue;
                }

                foreach ($l_item2 as $l_key3 => $l_item3) {
                    if (!is_array($l_item3) || empty($l_item3)) {
                        $preparedFrontendData[] = [$l_key, $l_key2, $l_key3];
                        continue;
                    }

                    foreach ($l_item3 as $l_key4 => $l_item4) {
                        $preparedFrontendData[] = [$l_key, $l_key2, $l_key3, $l_key4, $l_item4];
                    }
                }
            }
        }

        // Finally assign the data to the template.
        $this->template->assign('data', $preparedFrontendData);
    }
}
