<?php

namespace idoit\Module\UserSettings\SettingPage;

use idoit\Module\System\SettingPage\SettingPage;
use idoit\Module\UserSettings\TfaHelper;
use isys_application;
use isys_component_list;
use isys_component_template_navbar;

class TfaManagement extends SettingPage
{
    public function renderPage($navMode)
    {
        $tfa = isys_application::instance()->container->get('tfa');

        isys_component_template_navbar::getInstance()
            ->hide_all_buttons();

        $this->tpl
            ->assign('content_title', $this->lang->get('LC__USER_SETTINGS__TFA'))
            ->smarty_tom_add_rule('tom.content.navbar.cRecStatus.p_bInvisible=1')
            ->include_template('contentbottomcontent', \isys_module_user_settings::getPath() . 'templates/page/tfa-management.tpl');

        $rowHeaders = [
            'action'       => 'LC__USER_SETTINGS__TFA__COLUMN_ACTION',
            'isys_cats_person_list__title' => 'LC__USER_SETTINGS__TFA__COLUMN_USERNAME',
            'isys_cats_person_list__first_name' => 'LC__USER_SETTINGS__TFA__COLUMN_FIRSTNAME',
            'isys_cats_person_list__last_name' => 'LC__USER_SETTINGS__TFA__COLUMN_LASTNAME',
            'isys_catg_mail_addresses_list__title' => 'LC__USER_SETTINGS__TFA__COLUMN_EMAIL'
        ];

        $listData = $tfa->getTfaUsers();

        if (empty($listData)) {
            return;
        }

        $listComponent = new isys_component_list($listData);
        $listComponent->config($rowHeaders)
            ->disable_dragndrop()
            ->disableCheckboxes()
            ->set_row_modifier($this, 'modifyRow')
            ->setOptions([
                'columnSizes' => ['15%', '20%', '20%', '20%', '25%']
            ]);

        $properties = $listComponent->get_table_config()
            ->getProperties();
        $properties[0]->setIndexed(false);
        $listComponent->set_table_config($listComponent->get_table_config()
            ->setProperties($properties)
            ->setRowClickable(false));
        $listComponent->createTempTable();

        $this->tpl->assign('userList', $listComponent->getTempTableHtml());
    }

    /**
     * @param array $row
     *
     * @return void
     */
    public function modifyRow(array &$row)
    {
        $gearIcon = isys_application::instance()->www_path . 'images/axialis/basic/gear.svg';
        $linkIcon = isys_application::instance()->www_path . 'images/axialis/basic/link.svg';
        $userObjectId = (int)$row['isys_cats_person_list__isys_obj__id'];

        $url = isys_application::instance()->container->get('route_generator')->generate('cmdb.object.redirect', ['objectId' => $userObjectId]);
        $deactivate = $this->lang->get('LC__USER_SETTINGS__TFA__DEACTIVATE');
        $linkTooltip = $this->lang->get('LC__USER_SETTINGS__TFA__OBJECT_LINK');

        $row['action'] = '<button type="button" class="btn mr5" title="' . $deactivate . '" onClick="tfaDeactivate(this, ' . $userObjectId . ')">' .
            '<img src="' . $gearIcon . '" alt="" /><span>' . $deactivate . '</span>' .
            '</button>' .
            '<a target="_blank" class="btn" href="' . $url . '" title="' . $linkTooltip . '" data-tooltip="1">' .
            '<img src="' . $linkIcon . '" alt="" />' .
            '</a>';
    }
}
