[{isys_group name="tom.popup.tfa"}]
<div id="tfa-deactivate-popup">
    <div class="modal-header">
        <h1>[{isys type="lang" ident="LC__USER_SETTINGS__TFA__DEACTIVATE_TFA"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="modal-content p20">
        <h2>[{isys type="lang" ident="LC__USER_SETTINGS__TFA__DEACTIVATE_INFO"}]</h2>
        <p class="mt20 mb20">
            [{isys type="lang" ident="LC__USER_SETTINGS__TFA__DEACTIVATE_CONFIRM"}]
        </p>

        <div class="input-group input-size-block">
            [{isys type="f_text" name="tfa_code"}]
            <button type="button" class="btn save-button ml5" id="tfa_deactivate">
                <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" alt="" /><span>[{isys type="lang" ident="LC__USER_SETTINGS__TFA__VERIFY"}]</span>
            </button>
        </div>

    </div>

    <div class="modal-footer">
        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function() {
        const $popup = $('tfa-deactivate-popup');
        const $deactivateButton = $('tfa_deactivate');

        $popup.select('.popup-closer').invoke('on', 'click', function() {
            Modal.close($popup.up('.modal'));
        });

        preventAccidentalFormSubmit($popup);

        $deactivateButton.on('click', function() {
            $deactivateButton.down('img')
                .addClassName('animation-rotate')
                .writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg');

            new Ajax.Request(idoit.Router.getRoute('tfa.deactivate'), {
                method:     "post",
                parameters: {
                    code: $F('tfa_code')
                },
                onComplete: function (xhr) {
                    $deactivateButton.down('img')
                        .removeClassName('animation-rotate')
                        .writeAttribute('src', window.dir_images + 'axialis/basic/symbol-ok.svg');

                    if (!is_json_response(xhr, true)) {
                        return;
                    }

                    const json = xhr.responseJSON;

                    if (!json.success) {
                        idoit.Notify.error(json.message, { life: 5 });
                        return;
                    }

                    window.location.reload();
                }
            });
        });
    })();
</script>
[{/isys_group}]
