<?php

/**
 * i-doit Report Manager.
 *
 * @deprecated  It seems as if this class is no longer used - see "idoit\Module\Report\Export\TxtExport"
 *
 * @package     i-doit
 * @subpackage  Reports
 * @author      Dennis Bluemer <dbluemer@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_report_txt extends isys_report
{
    /**
     * Define the content-type.
     *
     * @var  string
     */
    private $m_content_type = 'text/plain';

    /**
     * Define the file extension.
     *
     * @var  string
     */
    private $m_fileExtension = 'txt';

    /**
     * Content-type getter.
     *
     * @return  string
     */
    public function getContentType()
    {
        return 'text/plain';
    }

    /**
     * This method will export the report to the desired format.
     *
     * @throws  Exception
     */
    public function export()
    {
        try {
            if (self::$m_as_download) {
                $this->output($this->toString());
            } else {
                $this->set_export_output($this->toString());
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    /**
     * Transfers the export string to the client with the given content-type information.
     *
     * @param  string $p_data
     */
    protected function output($p_data)
    {
        // Strip every "not-word" character.
        $l_title = strtolower(preg_replace('/\W+/', '_', $this->getTitle()));

        header('Content-Type: ' . $this->m_content_type);
        header('Expires: ' . date('D, d M Y H:i:s') . ' GMT');
        header('Content-Disposition: attachment; filename=' . date('ymd') . '-idoit-report-' . $l_title . '.' . $this->m_fileExtension);
        header('Pragma: no-cache');

        echo $p_data;
        die;
    }

    /**
     * Returns the report as a txt-String.
     *
     * @return string
     * @throws Exception
     */
    protected function toString()
    {
        $l_report = $this->query(true, false);
        $language = isys_application::instance()->container->get('language');

        $l_txt = '';

        if (is_array($l_report['headers'])) {
            foreach ($l_report['headers'] as $l_value) {
                $l_txt .= $l_value . '   ';
            }

            $l_txt .= PHP_EOL;
        } else {
            throw new Exception('Error processing report headers');
        }

        if (is_array($l_report['content'])) {
            foreach ($l_report['content'] as $l_data) {
                if (!is_array($l_data)) {
                    continue;
                }

                foreach ($l_data as $l_table => $l_value) {
                    // Replace <script>-Tags with content generated by QuickInfo-Tooltips.
                    $l_value = preg_replace('/<script[^>]*>[^<]*<[^>]script>/  ', '', $l_value);

                    // Remove other tags.
                    $l_value = strip_tags(str_replace('"', "'", $l_value));
                    if (!preg_match('/^__[\w]+__$/i', $l_table)) {
                        $l_txt .= $language->get($l_value) . '   ';
                    }
                }

                $l_txt .= PHP_EOL;
            }
        }

        return $l_txt;
    }
}
