<?php
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Component\Registry;

/**
 * Class Registry
 * Register the properties of components
 *
 * @package idoit\Component\Registry
 */
class Registry
{
    /**
     * @var array
     */
    protected $registered = [];

    /**
     * @param       $name
     * @param       $property
     */
    public function register($name, $property)
    {
        $this->registered[$name] = $property;
    }

    /**
     * @param $name
     *
     * @return mixed|null
     */
    public function find($name): mixed
    {
        if (isset($this->registered[$name])) {
            return $this->registered[$name];
        }

        return null;
    }
}
