<?php

namespace idoit\Component\Settings\Types;

/**
 * i-doit 'int' setting class - use this to extend settings.
 *
 * @package     idoit\Component
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class IntSetting extends AbstractSetting
{
    private string $placeholder;

    public function __construct(string $key, string $name, ?string $description = null, mixed $default = null, string $placeholder = '')
    {
        $this->type = 'int';

        parent::__construct($key, $name, $description, $default);

        $this->placeholder = $placeholder;
    }

    public function toArray(): array
    {
        $setting = parent::toArray();
        $setting['placeholder'] = $this->placeholder;

        return $setting;
    }
}
