<?php

namespace idoit\Model\Dao;

/**
 * i-doit Model.
 *
 * @package     i-doit
 * @subpackage  Core
 * @author      Dennis Stücken <dstuecken@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Base extends \isys_component_dao
{

    /**
     * Implode array of selectable columns.
     *
     * @param   array $mapping
     *
     * @return  string
     */
    public function selectImplode(array $mapping)
    {
        if (count($mapping) > 0) {
            array_walk($mapping, function (&$item, $key) {
                $item = $key . ' AS ' . $this->convert_sql_text($item);
            });

            return implode(', ', $mapping);
        }

        return '*';
    }
}
