<style type="text/css">
	#csv-import tr .btn {
		opacity: 0;
	}

	#csv-import tr:hover {
		background: #eee;
	}

	#csv-import tr:hover .btn {
		opacity: 1;
	}
</style>

<div id="csv-import">
	[{include file="modules/import/import_fileupload.tpl"}]

    <table class="mainTable" cellpadding="0" cellspacing="0">
        <thead>
        <tr>
            <th>[{isys type="lang" ident="LC__UNIVERSAL__FILE_TITLE"}] / [{isys type="lang" ident="LC__SETTINGS__SYSTEM__OPTIONS"}]</th>
        </tr>
        </thead>
        <tbody>
        [{foreach from=$import_files item="im"}]
            [{if ($im.type == 'csv')}]
            <tr class="[{cycle values="line1,line0"}]" data-filename="[{$im.filename}]">
                <td>
                    <div class="display-flex align-items-center">
                        <strong class="mr-auto">[{$im.stripped}]</strong>

                        <button type="button" class="fr btn btn-small start-import mr5">
                            <img src="[{$dir_images}]axialis/database/datasheet.svg" alt="" /><span>[{isys type="lang" ident="LC__MODULE__IMPORT__CSV__USE_FILE"}]</span>
                        </button>
                        <a href="[{$im.download}]" class="fr btn btn-small mr5">
                            <img src="[{$dir_images}]axialis/basic/symbol-download.svg" alt=""><span>[{isys type="lang" ident="LC__UNIVERSAL__DOWNLOAD_FILE"}]</span>
                        </a>
                        <button type="button" class="fr btn btn-small mr5 delete-import">
                            <img src="[{$dir_images}]axialis/industry-manufacturing/waste-bin.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__DELETE_FILE"}]</span>
                        </button>
                    </div>
                </td>
            </tr>
            [{/if}]
        [{/foreach}]
        </tbody>
    </table>

	<input type="hidden" name="file" id="selected_file" />
	<input type="hidden" name="type" id="type" value="csv" />
</div>

<script type="text/javascript">
	(function () {
		'use strict';

		const $container = $('csv-import');

		$container.select('.start-import').invoke('on', 'click', function (ev) {
			// Set import type and filename.
			$('selected_file').setValue(ev.findElement('button').up('tr').readAttribute('data-filename'));
			$('isys_form').writeAttribute('action', '[{$form_action_url}]').submit();
		});

		$container.select('.delete-import').invoke('on', 'click', function (ev) {
			const $tr = ev.findElement('button').up('tr');

            new Ajax.Request(document.location.href, {
                method:     'post',
                parameters: {
                    delete_import: $tr.readAttribute('data-filename')
                },
                onSuccess:  function (r) {
                    $tr.remove();
                    $('infoBox').down('div:not(.version)')
                        .update(new Element('img', { src: window.dir_images + 'icons/silk/information.png', className: 'vat mr5' }))
                        .insert(r.responseText).highlight();
                }
            });
		});
	})();
</script>
