<?php

/**
 * i-doit
 *
 * DAO: list for contract allocation
 *
 * @package     i-doit
 * @subpackage  CMDB_Category_lists
 * @author      Van Quyen Hoang <qhoang@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_dao_list_cats_contract_allocation extends isys_component_dao_category_table_list
{
    /**
     * Return constant of category.
     *
     * @return  integer
     */
    public function get_category()
    {
        return defined_or_default('C__CATS__CONTRACT_ALLOCATION');
    }

    /**
     * Return constant of category type.
     *
     * @return  integer
     */
    public function get_category_type()
    {
        return C__CMDB__CATEGORY__TYPE_SPECIFIC;
    }

    /**
     * Retrieve data for catg maintenance list view.
     *
     * @param   string  $p_str
     * @param   integer $p_objID
     * @param   integer $p_cRecStatus
     *
     * @return  isys_component_dao_result
     * @throws  isys_exception_general
     */
    public function get_result($p_str = null, $p_objID = null, $p_cRecStatus = null)
    {
        return isys_cmdb_dao_category_s_contract_allocation::instance($this->m_db)
            ->get_data(null, $p_objID, '', null, ($p_cRecStatus ?: $this->get_rec_status()));
    }

    /**
     * @param array $row
     */
    public function modify_row(&$row)
    {
        $row['isys_obj__title'] = isys_ajax_handler_quick_info::instance()->getQuickInfoReplacement(
            $row['isys_obj__id'],
            $row['isys_obj__title']
        );
    }

    /**
     * Returns array with table headers
     *
     * @return array
     */
    public function get_fields()
    {
        return [
            'isys_obj__id'         => 'ID',
            'isys_obj_type__title' => 'LC_UNIVERSAL__OBJECT_TYPE',
            'isys_obj__title'      => 'LC__CMDB__CATG__TITLE',
            'isys_catg_contract_assignment_list__description' => 'LC__CMDB__CAT__COMMENTARY',
        ];
    }
}
