<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage CMDB_Categories
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_cmdb_ui_category_g_database_sa extends isys_cmdb_ui_category_global
{
    /**
     * @param isys_cmdb_dao_category $categoryDao
     *
     * @return void
     * @throws Exception
     */
    public function process(isys_cmdb_dao_category $categoryDao)
    {
        $catData = $categoryDao->get_general_data();

        $this->fill_formfields($categoryDao, $rules, $catData);

        $rules['C__CATG__DATABASE_SA__SIZE']['p_strValue'] = isys_convert::formatNumber(isys_convert::memory(
            $catData["isys_catg_database_sa_list__size"],
            $catData["isys_catg_database_sa_list__size_unit"],
            C__CONVERT_DIRECTION__BACKWARD
        ));

        $rules['C__CATG__DATABASE_SA__MAX_SIZE']['p_strValue'] = isys_convert::formatNumber(isys_convert::memory(
            $catData["isys_catg_database_sa_list__max_size"],
            $catData["isys_catg_database_sa_list__max_size_unit"],
            C__CONVERT_DIRECTION__BACKWARD
        ));

        $this->get_template_component()
            ->assign('ajaxUrl', isys_helper_link::create_url([C__GET__AJAX => 1, C__GET__AJAX_CALL => 'database', 'func' => 'getDatabaseInstances']))
            ->assign('databaseAccess', $categoryDao->getDatabaseAccess($catData['isys_catg_database_sa_list__id']))
            ->smarty_tom_add_rules('tom.content.bottom.content', $rules);
    }
}
