<div id="technical-configuration-modal">
    <div class="modal-header">
        <h1>[{isys type="lang" ident="LC__CMDB__CUSTOM_CATEGORIES__CHANGE_ICON"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>
    <div class="modal-content p20 display-flex">
        <div>
            [{isys type="f_text" name="category-icon-search" p_strPlaceholder="Filter..." inputGroupMarginClass="" p_strClass="input-block"}]

            <br class="cb" />

            <div class="box mt5 overflow-auto input-size-block" id="category-icon-container">
                <table class="contentTable m0 w100 listing hover">
                    <tbody>
                    <tr class="no-hover">
                        <td><h2 class="ml5">[{isys type="lang" ident="LC_UNIVERSAL__CUSTOM_ICONS"}]</h2></td>
                    </tr>
                    [{foreach $categoryIcons.custom as $url => $icon}]
                        <tr>
                            <td class="mouse-pointer" title="[{$url}]">
                                <span><img src="[{$url}]" class="vam ml10 mr10" alt="" /> [{$icon}]</span>
                            </td>
                        </tr>
                    [{/foreach}]
                    <tr class="no-hover">
                        <td><h2 class="ml5">[{isys type="lang" ident="LC_UNIVERSAL__NEW_ICONS"}]</h2></td>
                    </tr>
                    [{foreach $categoryIcons.new as $url => $icon}]
                        <tr>
                            <td class="mouse-pointer" title="[{$url}]">
                                <span><img src="[{$url}]" class="vam ml10 mr10" alt="" /> [{$icon}]</span>
                            </td>
                        </tr>
                    [{/foreach}]
                    <tr class="no-hover">
                        <td><h2 class="ml5">[{isys type="lang" ident="LC_UNIVERSAL__OLD_ICONS"}]</h2></td>
                    </tr>
                    [{foreach $categoryIcons.old as $url => $icon}]
                        <tr>
                            <td class="mouse-pointer" title="[{$url}]">
                                <span><img src="[{$url}]" class="vam ml10 mr10" alt="" /> [{$icon}]</span>
                            </td>
                        </tr>
                    [{/foreach}]
                    </tbody>
                </table>
            </div>
        </div>

        <div class="px20" style="min-width: 500px">
            <h3>[{isys type="lang" ident="LC__CMDB__CUSTOM_CATEGORIES__UPLOAD_ICON"}]</h3>

            [{isys
                type="f_file_ajax"
                name="icon-upload"
                uploadType="cmdb.object-type-icon"
                p_strClass="my20 input-size-block"}]

            <div class="box-blue display-flex p10">
                <img src="[{$dir_images}]axialis/basic/button-info.svg" alt="info" class="mr10 align-self-start" />
                <div>
                    <p>[{isys type="lang" ident="LC__CMDB__CUSTOM_CATEGORIES__UPLOAD_ICON_CONDITION"}]</p>
                    <p class="mt10">[{isys type="lang" ident="LC__CMDB__CUSTOM_CATEGORIES__UPLOAD_ICON_CONDITION_FILESIZE" values=$uploadConditions.sizeLimit p_bHtmlEncode=false}]</p>
                    <p class="mt10">[{isys type="lang" ident="LC__CMDB__CUSTOM_CATEGORIES__UPLOAD_ICON_CONDITION_EXTENSION" values=$uploadConditions.validExtensions p_bHtmlEncode=false}]</p>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn mr5" id="accept-icon-selection">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" alt="" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]</span>
        </button>

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="">
            <span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<style>
    #icon-upload {
        min-height: 32px;
    }

    #category-icon-container {
        height: calc(100% - 40px);
    }

    #category-icon-container img {
        max-width: 16px;
        max-height: 16px;
    }
</style>

<script>
    (function () {
        const $modal = $('technical-configuration-modal');

        $modal.select('.popup-closer').invoke('on', 'click', function () {
            Modal.close($modal.up('.modal'));
        });

        const $iconSelection = $('category-icon');
        const $acceptIconButton = $('accept-icon-selection');
        const $categoryIconsSearch = $('category-icon-search');
        const $categoryIconContainer = $('category-icon-container').down('tbody');

        $categoryIconsSearch.on('keyup', function () {
            delay(function () {
                const query = $categoryIconsSearch.getValue().toLowerCase();

                $categoryIconContainer.select('tr:not(.no-hover)')
                    .invoke('removeClassName', 'hide')
                    .filter(function($row) {
                        return $row.innerText.toLowerCase().indexOf(query) < 0;
                    })
                    .invoke('addClassName', 'hide');
            }, 250);
        });

        $categoryIconContainer.on('click', 'td', function (ev) {
            const $td = ev.findElement('td');

            if ($td.up('tr.no-hover')) {
                return;
            }

            $categoryIconContainer.select('td').invoke('removeClassName', 'selected');
            $td.addClassName('selected');
        });

        $acceptIconButton.on('click', function () {
            const selectedIcon = $categoryIconContainer.down('td.selected').readAttribute('title');

            $iconSelection.setValue(selectedIcon);
            $('current-icon').writeAttribute('src', selectedIcon);

            Modal.close($modal.up('.modal'));
        })

        try {
            let $selectedIcon = $categoryIconContainer.down('td[title="' + $iconSelection.getValue() + '"]');

            if (!$selectedIcon) {
                $selectedIcon = $categoryIconContainer.down('td[title="[{$defaultIcon}]"]');
            }

            $selectedIcon.addClassName('selected').scrollIntoView(true);
        } catch (e) {
            // We might not have any selected icons or images yet.
        }

        // Add new selectable icon after successful upload.
        idoit.callbackManager.registerCallback('smarty-ajax-file-upload', function(json) {
            idoit.Notify.success('[{isys type="lang" ident="LC__CMDB__CUSTOM_CATEGORIES__UPLOAD_ICON_SUCCESS"}]');

            // Replace starting slash, will be added by generic logic later.
            const $newRow = new Element('td', { title: json.callbackResult.replace(/^\//, '') })
                .update(new Element('span')
                    .update(new Element('img', { className: 'vam ml10 mr10', src: json.callbackResult }))
                    .insert(json.callbackResult.split(':').last()));

            $categoryIconContainer.down('tr').insert({ after: new Element('tr').update($newRow) });

            $newRow.simulate('click');

            $categoryIconContainer.down('.selected').scrollIntoView(true);
        });
    })();
</script>
