<div id="technical-configuration-modal">
    <div class="modal-header">
        <h1>[{isys type="lang" ident="LC__SYSTEM__CUSTOM_CATEGORIES__SHOW_TECHNICAL_INFO"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>
    <div class="modal-content p20">
        <div class="display-flex">
            <div>
                <h3>Configuration:</h3>
                <pre class="box-neutral-200">[{json_encode($apiExampleConfig, JSON_PRETTY_PRINT)}]</pre>
            </div>

            <div class="ml10">
                <h3>Structure Info:</h3>
                <pre class="box-neutral-200">{
    "Field Key / Identifier": {
        "type": "Field Type",
        "popup": "Popup Type",
        "title": "Title",
        "identifier": "Group ID",
        "show_in_list": 0/1
    }
}</pre>
            </div>
        </div>

        <h2 class="my20">API-Examples:</h2>

        <div class="my20">
            <h3>Read</h3>
            <pre class="box-neutral-200 p10">[{json_encode($apiExample.read, JSON_PRETTY_PRINT)}]</pre>
        </div>

        <div class="my20">
            <h3>Write</h3>
            <pre class="box-neutral-200 p10">[{json_encode($apiExample.create, JSON_PRETTY_PRINT)}]</pre>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" alt="">
            <span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<style>
    #technical-configuration-modal .display-flex > div {
        min-width: 25%;
        width: 100%;
        max-width: 50%;
        overflow: hidden;
    }

    #technical-configuration-modal .display-flex > div > pre {
        width: 100%;
        overflow: auto;
        padding: 10px;
        margin-top: 10px;
    }
</style>

<script>
    (function () {
        const $modal = $('technical-configuration-modal');

        $modal.select('.popup-closer').invoke('on', 'click', function () {
            Modal.close($modal.up('.modal'));
        });
    })();
</script>
