<?php

/**
 * i-doit
 *
 * Auth: Class for i-doit authorization rules.
 *
 * @package     Modules
 * @subpackage  Analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.4
 */
class isys_auth_itservice extends isys_auth implements isys_auth_interface
{
    /**
     * Container for singleton instance
     *
     * @var isys_auth_itservice
     */
    private static $m_instance;

    /**
     * Retrieve singleton instance of authorization class
     *
     * @return isys_auth_itservice
     * @author Selcuk Kekec <skekec@i-doit.com>
     */
    public static function instance()
    {
        // If the DAO has not been loaded yet, we initialize it now.
        if (self::$m_dao === null) {
            self::$m_dao = new isys_auth_dao(isys_application::instance()->container->get('database'));
        }

        if (self::$m_instance === null) {
            self::$m_instance = new self;
        }

        return self::$m_instance;
    }

    /**
     * Method for returning the available auth-methods. This will be used for the GUI.
     *
     * @return  array
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function get_auth_methods()
    {
        return [
            'type_config'   => [
                'title'  => 'LC__ITSERVICE__AUTH__TYPE_CONFIG',
                'type'   => 'boolean',
                'rights' => [
                    isys_auth::VIEW,
                    isys_auth::EDIT,
                    isys_auth::DELETE,
                    isys_auth::SUPERVISOR
                ]
            ],
            'filter_config' => [
                'title'  => 'LC__ITSERVICE__AUTH__FILTER_CONFIG',
                'type'   => 'boolean',
                'rights' => [
                    isys_auth::VIEW,
                    isys_auth::EDIT,
                    isys_auth::DELETE,
                    isys_auth::SUPERVISOR
                ]
            ]
        ];
    }

    /**
     * Get ID of related module
     *
     * @return int
     */
    public function get_module_id()
    {
        return defined_or_default('C__MODULE__ITSERVICE');
    }

    /**
     * Get title of related module
     *
     * @return string
     */
    public function get_module_title()
    {
        return 'LC__MODULE__ITSERVICE';
    }

    /**
     * Method for checking, if the user is allowed to view / execute a simulation.
     *
     * @param   integer $p_right
     * @param   string  $p_param
     *
     * @return  boolean
     * @throws  isys_exception_auth
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function type_config($p_right, $p_param)
    {
        if (!$this->is_auth_active()) {
            return true;
        }

        return $this->generic_right($p_right, 'type_config', $p_param, new isys_exception_auth(isys_application::instance()->container->get('language')
            ->get('LC__AUTH__EXCEPTION__MISSING_METHOD_RIGHT', isys_auth::get_right_name($p_right))));
    }

    /**
     * Method for checking, if the user is allowed to administrate dataquality profiles (add, delete, publish).
     *
     * @param   integer $p_right
     * @param   string  $p_param
     *
     * @return  boolean
     * @throws  isys_exception_auth
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function filter_config($p_right, $p_param)
    {
        if (!$this->is_auth_active()) {
            return true;
        }

        return $this->generic_right($p_right, 'filter_config', $p_param, new isys_exception_auth(isys_application::instance()->container->get('language')
            ->get('LC__AUTH__EXCEPTION__MISSING_METHOD_RIGHT', isys_auth::get_right_name($p_right))));
    }
}
