<?php

/**
 * i-doit
 *
 * IT-Service DAO for the CMDB.
 *
 * @package     modules
 * @subpackage  itservice
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.10
 */
class isys_cmdb_dao_list_objects_it_service extends isys_cmdb_dao_list_objects
{
    /**
     * @param  array|int $p_object_type
     *
     * @return $this
     */
    public function set_object_type($p_object_type)
    {
        parent::set_object_type($p_object_type);

        // @see  ID-6805  In "add-on" context, we don't limit the object types.
        if ($_GET[C__GET__MODULE_ID] == C__MODULE__ITSERVICE) {
            $this->m_object_type['isys_obj_type__id'] = null;
        }

        return $this;
    }

    /**
     * Method for retrieving additional conditions to a object type.
     *
     * @return  string
     * @author  Pavel Abduramanov <pabduramanov@i-doit.com>
     */
    public function get_additional_conditions()
    {
        $l_return = '';

        if (isset($_GET[C__GET__ID])) {
            $l_return = ' AND its_type_list.isys_catg_its_type_list__isys_its_type__id = ' . $this->convert_sql_id($_GET[C__GET__ID]) . ' ';
        } elseif ($_GET[C__GET__MODULE_ID] == C__MODULE__ITSERVICE) {
            // @see  ID-6805  In "add-on" context, we join the category assignment, so we only display objects of types that have the "Service" category.
            $l_return = ' AND isysgui_catg__const = \'C__CATG__SERVICE\' ';
        }

        return $l_return . parent::get_additional_conditions();
    }

    /**
     * Get additional join to the table, which is in use in additional conditions
     *
     * @return string
     */
    public function get_additional_joins()
    {
        if (isset($_GET[C__GET__ID])) {
            return ' INNER JOIN isys_catg_its_type_list AS its_type_list ON its_type_list.isys_catg_its_type_list__isys_obj__id = obj_main.isys_obj__id ';
        }

        // @see  ID-6805  In "add-on" context, we join the category assignment, so we only display objects of types that have the "Service" category.
        if ($_GET[C__GET__MODULE_ID] == C__MODULE__ITSERVICE) {
            return ' INNER JOIN isys_obj_type_2_isysgui_catg ON isys_obj_type_2_isysgui_catg__isys_obj_type__id = obj_main.isys_obj__isys_obj_type__id 
                INNER JOIN isysgui_catg ON isysgui_catg__id = isys_obj_type_2_isysgui_catg__isysgui_catg__id ';
        }

        return '';
    }
}
