<?php

namespace idoit\Module\License\Event\Tenant;

use Symfony\Component\EventDispatcher\GenericEvent;

class TenantAddedEvent extends GenericEvent
{
    /**
     * @var int
     */
    private $tenantId;

    const NAME = 'tenant.added';

    public function __construct($tenantId)
    {
        $this->tenantId = $tenantId;
    }

    /**
     * @return int
     */
    public function getTenantId()
    {
        return $this->tenantId;
    }
}
