<?php

namespace idoit\Module\License;

use GuzzleHttp\Client;
use idoit\Module\License\Event\Subscriber\Admin\LicenseSubscriber;
use idoit\Module\License\Event\Subscriber\Admin\TenantSubscriber;
use isys_component_database;
use isys_locale;

class LicenseServiceFactory
{
    /**
     * Creates a preconfigured default instance of LicenseService
     *
     * @param isys_component_database $databaseSystem
     * @param string $licenseToken
     *
     * @return LicenseService
     */
    public static function createDefaultLicenseService(isys_component_database $databaseSystem, $licenseToken)
    {
        $eventDispatcher = new \Symfony\Component\EventDispatcher\EventDispatcher();

        $licenseService = new LicenseService(
            $databaseSystem,
            new \idoit\Module\License\Crypt\DefaultEncryption(),
            $eventDispatcher,
            new Client(),
            $licenseToken
        );


        $eventDispatcher->addSubscriber(new LicenseSubscriber($licenseService));
        $eventDispatcher->addSubscriber(new TenantSubscriber($licenseService));

        return $licenseService;
    }
}
