<?php

/**
 * i-doit
 *
 * Dashboard widget class.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.5.0
 */
class isys_dashboard_widgets_cmdb_statuslivecycle extends isys_dashboard_widgets
{
    /**
     * Path and Filename of the configuration template.
     *
     * @var  string
     */
    protected $m_config_tpl_file = '';

    /**
     * Path and Filename of the template.
     *
     * @var  string
     */
    protected $m_tpl_file = '';

    /**
     * Returns a boolean value, if the current widget has an own configuration page.
     *
     * @return  boolean
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function has_configuration()
    {
        return true;
    }

    /**
     * Init method.
     *
     * @param   array $p_config
     *
     * @return  $this
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function init($p_config = [])
    {
        $this->m_tpl_file = __DIR__ . '/templates/widget.tpl';
        $this->m_config_tpl_file = __DIR__ . '/templates/config.tpl';

        return parent::init($p_config);
    }

    /**
     * Method for loading the widget configuration.
     *
     * @param   array   $p_row The current widget row from "isys_widgets".
     * @param   integer $p_id  The ID from "isys_widgets_config".
     *
     * @return  string
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function load_configuration(array $p_row, $p_id)
    {
        $l_objects = [];

        if (isset($this->m_config['objects']) && isys_format_json::is_json_array($this->m_config['objects'])) {
            $l_objects = $this->m_config['objects'];
        }

        return $this->m_tpl->activate_editmode()
            ->assign('title', isys_application::instance()->container->get('language')
                ->get('LC__MONITORING__WIDGET__NOT_OK_HOSTS__HOST_SELECTION'))
            ->assign('objects', $l_objects)
            ->fetch($this->m_config_tpl_file);
    }

    /**
     * Render method.
     *
     * @param   string $p_unique_id
     *
     * @return  string
     * @throws  isys_exception_general
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function render($p_unique_id)
    {
        $l_dao = isys_cmdb_dao_status::instance(isys_application::instance()->database);
        $cmdbStatus = $objectData = [];

        if (isset($this->m_config['objects']) && isys_format_json::is_json_array($this->m_config['objects'])) {
            $this->m_config['objects'] = isys_format_json::decode($this->m_config['objects']);

            if (is_array($this->m_config['objects']) && count($this->m_config['objects'])) {
                // Retrieve the CMDB status.
                $cmdbStatusRes = $l_dao->get_cmdb_status(null, ' ORDER BY isys_cmdb_status__id ASC ');

                if (count($cmdbStatusRes)) {
                    while ($cmdbStatusRow = $cmdbStatusRes->get_row()) {
                        if ($cmdbStatusRow['isys_cmdb_status__id'] == defined_or_default('C__CMDB_STATUS__IDOIT_STATUS') ||
                            $cmdbStatusRow['isys_cmdb_status__id'] == defined_or_default('C__CMDB_STATUS__IDOIT_STATUS_TEMPLATE')) {
                            continue;
                        }

                        $cmdbStatus[$cmdbStatusRow['isys_cmdb_status__id']] = isys_application::instance()->container->get('language')
                            ->get($cmdbStatusRow['isys_cmdb_status__title']);
                    }
                }

                // Retrieve the changes of the given objects.
                $objectRes = $l_dao->get_changes_by_obj_id($this->m_config['objects']);

                if (count($objectRes)) {
                    while ($objectRow = $objectRes->get_row()) {
                        if (!isset($objectData[$objectRow['isys_obj__id']])) {
                            $objectData[$objectRow['isys_obj__id']] = [
                                [
                                    'objectId'        => $objectRow['isys_obj__id'],
                                    'objectTitle'     => $objectRow['isys_obj__title'],
                                    'objectTypeTitle' => isys_application::instance()->container->get('language')
                                        ->get($objectRow['isys_obj_type__title']),
                                    'objectTypeColor' => $objectRow['isys_obj_type__color'],
                                    'objectColor'     => isys_helper_color::pastel_color_from_string($objectRow['isys_obj__sysid']),
                                ],
                                [// CMDB-Status changes go here.
                                ]
                            ];
                        }

                        $objectData[$objectRow['isys_obj__id']][1][] = [
                            'date'   => $objectRow['isys_cmdb_status_changes__timestamp'],
                            'status' => $cmdbStatus[$objectRow['isys_cmdb_status_changes__isys_cmdb_status__id']]
                        ];
                    }
                }
            }
        }

        sort($cmdbStatus);

        return $this->m_tpl->assign('unique_id', $p_unique_id)
            ->assign('title', isys_application::instance()->container->get('language')
                ->get('LC__WIDGET__LIVECYCLE_CMDBSTATUS'))
            ->assign('objectData', array_values($objectData))
            ->assign('cmdbStatus', array_values($cmdbStatus))
            ->fetch($this->m_tpl_file);
    }
}
